import { jsx as _jsx, jsxs as _jsxs } from "preact/jsx-runtime";
import classNames from 'classnames';
import { h } from 'preact';
import { CancelBtn, DoneBtn, PauseResumeButton, ProgressBarComplete, ProgressBarError, ProgressBarProcessing, ProgressBarUploading, RetryBtn, UploadBtn, } from './Components.js';
import calculateProcessingProgress from './calculateProcessingProgress.js';
import statusBarStates from './StatusBarStates.js';
const { STATE_ERROR, STATE_WAITING, STATE_PREPROCESSING, STATE_UPLOADING, STATE_POSTPROCESSING, STATE_COMPLETE, } = statusBarStates;
export default function StatusBarUI({ newFiles, allowNewUpload, isUploadInProgress, isAllPaused, resumableUploads, error, hideUploadButton = undefined, hidePauseResumeButton = false, hideCancelButton = false, hideRetryButton = false, recoveredState, uploadState, totalProgress, files, supportsUploadProgress, hideAfterFinish = false, isSomeGhost, doneButtonHandler = undefined, isUploadStarted, i18n, startUpload, uppy, isAllComplete, showProgressDetails = undefined, numUploads, complete, totalSize, totalETA, totalUploadedSize, }) {
    function getProgressValue() {
        switch (uploadState) {
            case STATE_POSTPROCESSING:
            case STATE_PREPROCESSING: {
                const progress = calculateProcessingProgress(files);
                if (progress.mode === 'determinate') {
                    return progress.value * 100;
                }
                return totalProgress;
            }
            case STATE_ERROR: {
                return null;
            }
            case STATE_UPLOADING: {
                if (!supportsUploadProgress) {
                    return null;
                }
                return totalProgress;
            }
            default:
                return totalProgress;
        }
    }
    function getIsIndeterminate() {
        switch (uploadState) {
            case STATE_POSTPROCESSING:
            case STATE_PREPROCESSING: {
                const { mode } = calculateProcessingProgress(files);
                return mode === 'indeterminate';
            }
            case STATE_UPLOADING: {
                if (!supportsUploadProgress) {
                    return true;
                }
                return false;
            }
            default:
                return false;
        }
    }
    const progressValue = getProgressValue();
    const width = progressValue ?? 100;
    const showUploadBtn = !error &&
        newFiles &&
        ((!isUploadInProgress && !isAllPaused) || recoveredState) &&
        allowNewUpload &&
        !hideUploadButton;
    const showCancelBtn = !hideCancelButton &&
        uploadState !== STATE_WAITING &&
        uploadState !== STATE_COMPLETE;
    const showPauseResumeBtn = resumableUploads &&
        !hidePauseResumeButton &&
        uploadState === STATE_UPLOADING;
    const showRetryBtn = error && !isAllComplete && !hideRetryButton;
    const showDoneBtn = doneButtonHandler && uploadState === STATE_COMPLETE;
    const progressClassNames = classNames('uppy-StatusBar-progress', {
        'is-indeterminate': getIsIndeterminate(),
    });
    const statusBarClassNames = classNames('uppy-StatusBar', `is-${uploadState}`, { 'has-ghosts': isSomeGhost });
    const progressBarStateEl = (() => {
        switch (uploadState) {
            case STATE_PREPROCESSING:
            case STATE_POSTPROCESSING:
                return (_jsx(ProgressBarProcessing, { progress: calculateProcessingProgress(files) }));
            case STATE_COMPLETE:
                return _jsx(ProgressBarComplete, { i18n: i18n });
            case STATE_ERROR:
                return (_jsx(ProgressBarError, { error: error, i18n: i18n, numUploads: numUploads, complete: complete }));
            case STATE_UPLOADING:
                return (_jsx(ProgressBarUploading, { i18n: i18n, supportsUploadProgress: supportsUploadProgress, totalProgress: totalProgress, showProgressDetails: showProgressDetails, isUploadStarted: isUploadStarted, isAllComplete: isAllComplete, isAllPaused: isAllPaused, newFiles: newFiles, numUploads: numUploads, complete: complete, totalUploadedSize: totalUploadedSize, totalSize: totalSize, totalETA: totalETA, startUpload: startUpload }));
            default:
                return null;
        }
    })();
    const atLeastOneAction = showUploadBtn ||
        showRetryBtn ||
        showPauseResumeBtn ||
        showCancelBtn ||
        showDoneBtn;
    const thereIsNothingInside = !atLeastOneAction && !progressBarStateEl;
    const isHidden = thereIsNothingInside || (uploadState === STATE_COMPLETE && hideAfterFinish);
    if (isHidden) {
        return null;
    }
    return (_jsxs("div", { className: statusBarClassNames, children: [_jsx("div", { className: progressClassNames, style: { width: `${width}%` }, role: "progressbar", "aria-label": `${width}%`, "aria-valuetext": `${width}%`, "aria-valuemin": 0, "aria-valuemax": 100, "aria-valuenow": progressValue }), progressBarStateEl, _jsxs("div", { className: "uppy-StatusBar-actions", children: [showUploadBtn ? (_jsx(UploadBtn, { newFiles: newFiles, isUploadStarted: isUploadStarted, recoveredState: recoveredState, i18n: i18n, isSomeGhost: isSomeGhost, startUpload: startUpload, uploadState: uploadState })) : null, showRetryBtn ? _jsx(RetryBtn, { i18n: i18n, uppy: uppy }) : null, showPauseResumeBtn ? (_jsx(PauseResumeButton, { isAllPaused: isAllPaused, i18n: i18n, isAllComplete: isAllComplete, resumableUploads: resumableUploads, uppy: uppy })) : null, showCancelBtn ? _jsx(CancelBtn, { i18n: i18n, uppy: uppy }) : null, showDoneBtn ? (_jsx(DoneBtn, { i18n: i18n, doneButtonHandler: doneButtonHandler })) : null] })] }));
}
