import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "preact/jsx-runtime";
import prettierBytes from '@transloadit/prettier-bytes';
import truncateString from '@uppy/utils/lib/truncateString';
import { h } from 'preact';
import MetaErrorMessage from '../MetaErrorMessage.js';
const renderFileName = (props) => {
    const { author, name } = props.file.meta;
    function getMaxNameLength() {
        if (props.isSingleFile && props.containerHeight >= 350) {
            return 90;
        }
        if (props.containerWidth <= 352) {
            return 35;
        }
        if (props.containerWidth <= 576) {
            return 60;
        }
        // When `author` is present, we want to make sure
        // the file name fits on one line so we can place
        // the author on the second line.
        return author ? 20 : 30;
    }
    return (_jsx("div", { className: "uppy-Dashboard-Item-name", title: name, children: truncateString(name, getMaxNameLength()) }));
};
const renderAuthor = (props) => {
    const { author } = props.file.meta;
    const providerName = props.file.remote?.providerName;
    const dot = `\u00B7`;
    if (!author) {
        return null;
    }
    return (_jsxs("div", { className: "uppy-Dashboard-Item-author", children: [_jsx("a", { href: `${author.url}?utm_source=Companion&utm_medium=referral`, target: "_blank", rel: "noopener noreferrer", children: truncateString(author.name, 13) }), providerName ? (_jsxs(_Fragment, { children: [` ${dot} `, providerName, ` ${dot} `] })) : null] }));
};
const renderFileSize = (props) => props.file.size && (_jsx("div", { className: "uppy-Dashboard-Item-statusSize", children: prettierBytes(props.file.size) }));
const ReSelectButton = (props) => props.file.isGhost && (_jsxs("span", { children: [' \u2022 ', _jsx("button", { className: "uppy-u-reset uppy-c-btn uppy-Dashboard-Item-reSelect", type: "button", onClick: () => props.toggleAddFilesPanel(true), children: props.i18n('reSelect') })] }));
const ErrorButton = ({ file, onClick, }) => {
    if (file.error) {
        return (_jsx("button", { className: "uppy-u-reset uppy-c-btn uppy-Dashboard-Item-errorDetails", "aria-label": file.error, "data-microtip-position": "bottom", "data-microtip-size": "medium", onClick: onClick, type: "button", children: "?" }));
    }
    return null;
};
export default function FileInfo(props) {
    const { file, i18n, toggleFileCard, metaFields, toggleAddFilesPanel, isSingleFile, containerHeight, containerWidth, } = props;
    return (_jsxs("div", { className: "uppy-Dashboard-Item-fileInfo", "data-uppy-file-source": file.source, children: [_jsxs("div", { className: "uppy-Dashboard-Item-fileName", children: [renderFileName({
                        file,
                        isSingleFile,
                        containerHeight,
                        containerWidth,
                    }), _jsx(ErrorButton, { file: file, onClick: () => alert(file.error) })] }), _jsxs("div", { className: "uppy-Dashboard-Item-status", children: [renderAuthor({ file }), renderFileSize({ file }), ReSelectButton({ file, toggleAddFilesPanel, i18n })] }), _jsx(MetaErrorMessage, { file: file, i18n: i18n, toggleFileCard: toggleFileCard, metaFields: metaFields })] }));
}
