<?php

/*
 *  ========================================================================
 *  * Open eClass
 *  * E-learning and Course Management System
 *  * ========================================================================
 *  * Copyright 2003-2024, Greek Universities Network - GUnet
 *  *
 *  * Open eClass is an open platform distributed in the hope that it will
 *  * be useful (without any warranty), under the terms of the GNU (General
 *  * Public License) as published by the Free Software Foundation.
 *  * The full license can be read in "/info/license/license_gpl.txt".
 *  *
 *  * Contact address: GUnet Asynchronous eLearning Group
 *  *                  e-mail: info@openeclass.org
 *  * ========================================================================
 *
 */
$guest_allowed = true;
require_once '../../include/baseTheme.php';
require_once 'include/lib/forcedownload.php';
require_once 'include/lib/mediaresource.factory.php';
require_once 'modules/progress/ViewingEvent.php';

if (!isset($_GET['course']) || !isset($_GET['id'])) {
    header("Location: $urlServer");
    exit();
}

if (strpos($_GET['course'], '..') !== false) {
    header("Location: $urlServer");
    exit();
}

$disposition = 'inline';
if (isset($_GET['attachment'])) {
    $disposition = 'attachment';
}


// locate course id
$course_id = null;
$res1 = Database::get()->querySingle("SELECT course.id FROM course WHERE course.code = ?s", q($_GET['course']));
if ($res1) {
    $course_id = intval($res1->id);
}

if ($course_id == null) {
    header("Location: $urlServer");
    exit();
}

if ($uid) {
    require_once 'include/action.php';
    $action = new action();
    $action->record(MODULE_ID_VIDEO);
}

// ----------------------
// download video
// ----------------------
$res2 = Database::get()->querySingle("SELECT * FROM video
                  WHERE course_id = ?d AND id = ?d", $course_id, $_GET['id']);

if (!$res2) {
    header("Location: $urlServer");
    exit();
}

$valid = $uid || course_status($course_id) == COURSE_OPEN || (isset($_GET['token']) && token_validate($file_info->path, $_GET['token'], 30));
if (!$valid) {
    header("Location: $urlServer");
    exit();
}

// trigger gamification
$videoData = new stdClass();
$videoData->courseId = $course_id;
$videoData->uid = $uid;
$videoData->activityType = ViewingEvent::VIDEO_ACTIVITY;
$videoData->module = MODULE_ID_VIDEO;
$videoData->resource = intval($_GET['id']);
ViewingEvent::trigger(ViewingEvent::NEWVIEW, $videoData);

$vObj = MediaResourceFactory::initFromVideo($res2);
$real_file = $webDir . "/video/" . q($_GET['course']) . q($vObj->getPath());
send_file_to_client($real_file, my_basename(q($vObj->getUrl())), $disposition, true);
