<?php
/*
 *  ========================================================================
 *  * Open eClass
 *  * E-learning and Course Management System
 *  * ========================================================================
 *  * Copyright 2003-2024, Greek Universities Network - GUnet
 *  *
 *  * Open eClass is an open platform distributed in the hope that it will
 *  * be useful (without any warranty), under the terms of the GNU (General
 *  * Public License) as published by the Free Software Foundation.
 *  * The full license can be read in "/info/license/license_gpl.txt".
 *  *
 *  * Contact address: GUnet Asynchronous eLearning Group
 *  *                  e-mail: info@openeclass.org
 *  * ========================================================================
 *
 */

/* * ********************************************************
 * General Messages - Feel free to suit them in your needs
 * ******************************************************** */

$langEclass = "Πλατφόρμα Συνεργασίας";

$langTeacher = "Συντονιστής";
$langOfTeacher = "Συντονιστή";
$langTeachers = "Συντονιστές";
$langOfTeachers = "Συντονιστών";

$langsTeacher = "συντονιστής";
$langsOfTeacher = "συντονιστή";
$langsTeachers = "συντονιστές";
$langsOfTeachers = "συντονιστών";
$langCTeacher = "ΣΥΝΤΟΝΙΣΤΗΣ";

$langConsultant = "Σύμβουλος";
$langOfConsultant = "Συμβούλου";
$langConsultants = "Σύμβουλους";
$langOfConsultants = "Συμβούλων";

$langsConsultant = "σύμβουλος";
$langsOfConsultant = "συμβούλου";
$langsConsultants = "σύμβουλοι";
$langsOfConsultants = "συμβούλων";

$langCourseAdminTeacher = "Διαχειριστής - Συντονιστής";
$langOfCourseAdminTeacher = "Διαχειριστή - Συντονιστή";
$langCourseAdminTeachers = "Διαχειριστές - Συντονιστές";
$langOfCourseAdminTeachers = "Διαχειριστών - Συντονιστών";

$langsCourseAdminTeacher = "διαχειριστής - συντονιστής";
$langsOfCourseAdminTeacher = "διαχειριστή - συντονιστή";
$langsCourseAdminTeachers = "διαχειριστές - συντονιστές";
$langsOfCourseAdminTeachers = "διαχειριστών - συντονιστών";

$langEditor = "Βοηθός συντονιστή";
$langOfEditor = "Βοηθού συντονιστή";
$langsEditor = "βοηθός συντονιστή";
$langsOfEditor = "βοηθού συντονιστή";

$langStudent = "Μέλος - ωφελούμενος";
$langOfStudent = "Μέλους - ωφελούμενου";
$langStudents = "Μέλη - ωφελούμενοι";
$langOfStudents = "Μελών - ωφελούμενων";
$langCStudent = "ΜΕΛΟΣ";
$langCStudent2 = "ΜΕΛΟΣ";

$langsStudent = "μέλος - ωφελούμενος";
$langsOfStudent = "μέλους - ωφελούμενου";
$langsStudents = "μέλη - ωφελούμενοι";
$langsOfStudents = "μελών - ωφελούμενων";
$langsOfStudentss = "μέλη - ωφελούμενοι";
$langsstudent_acc = "μέλος- ωφελούμενος";

$langCourse = "Συνεργασία";
$langCourses = "Συνεργασίες";
$langOfCourses = "Συνεργασιών";
$langOfCourse = "Συνεργασίας";

$langsCourse = "συνεργασία";
$langsCourses = "συνεργασίες";
$langsOfCourse = "συνεργασίας";
$langsOfCourses = "συνεργασιών";
$langCourseS = "συνεργασίας";
$langMyCourses = "Οι συνεργασίες μου";

$langInfoAbout = "Η πλατφόρμα $siteName αποτελεί ένα ολοκληρωμένο Σύστημα Διαχείρισης Ηλεκτρονικών Συνεργασιών. Ακολουθεί τη φιλοσοφία του λογισμικού ανοικτού κώδικα και υποστηρίζει την υπηρεσία Ασύγχρονης Τηλεκπαίδευσης χωρίς περιορισμούς και δεσμεύσεις. Η πρόσβαση στην υπηρεσία γίνεται με τη χρήση ενός απλού φυλλομετρητή (web browser) χωρίς την απαίτηση εξειδικευμένων τεχνικών γνώσεων.";

$langSiteUrl = "URL της πλατφόρμας συνεργασίας";
$langInstall = "Eγκατάσταση της πλατφόρμας συνεργασίας";
$langLocale = 'el_GR.UTF-8';
$langIntro = "Η πλατφόρμα <strong>$siteName</strong> είναι ένα ολοκληρωμένο Σύστημα Διαχείρισης Ηλεκτρονικών $langOfCourses και υποστηρίζει την Υπηρεσία Ασύγχρονης Τηλεκπαίδευσης στο <a href=\"$InstitutionUrl\" target=\"_blank\" class=mainpage>$Institution</a>.";
$langTotalCourses = "Αριθμός $langsOfCourses";
$langInCourses = "στην $langsCourse";
$langInCoursesL = "στην $langsCourse";

// For the logged-out user:
$langUserWithRights = "Χρήστη με δικαιώματα δημιουργίας συνεργασιών";
$langUserWithNoRights = "Χρήστη χωρίς δικαιώματα δημιουργίας συνεργασιών";
$langUsersWithTeacherRights = "Χρήστες με δικαιώματα δημιουργίας συνεργασιών";
$langUsersWithNoTeacherRights = "Χρήστες χωρίς δικαιώματα δημιουργίας συνεργασιών";
$langWithRights = "με δικαίωμα δημιουργίας συνεργασιών";
$langWithCourseCreationRights = "δημιουργίας συνεργασιών";
$langWithNoCourseCreationRights = "όχι δημιουργίας συνεργασιών";
$langInfoEnableCourseRegistration = "Ο χρήστης μπορεί να εγγραφεί σε $langsCourses";


/* * ******************************************
 * addadmin.php
 * ******************************************* */
$langHelpPowerUser = "Ο βοηθός διαχειριστή διαχειρίζεται τις $langsCourses και τους χρήστες";

/* * **************************************************
 * admin.php
 * ************************************************** */
// index
$langSpeeSubscribe = "Εγγραφή ως Διαχειριστής $langOfCourse";
$langListCours = "Λίστα $langOfCourses / Ενέργειες";
$langProfReg = "Εγγραφή $langOfTeacher";
$langProfOpen = "Αιτήσεις $langOfTeachers";
$langUserOpen = "Αιτήσεις $langOfStudents";
$langAdminProf = "Διαχείριση $langOfTeachers";
$langAdminCours = "Διαχείριση $langsOfCourses";
$langOpenRequests = "Ανοικτές αιτήσεις " . $langsOfTeachers;
$langNoOpenRequests = "Δεν βρέθηκαν ανοικτές αιτήσεις " . $langsOfTeachers;
$langLastLesson = "Τελευταία $langsCourse που δημιουργήθηκε:";
$langLastProf = "Τελευταία εγγραφή $langsOfTeacher:";
$langLastStud = "Τελευταία εγγραφή $langsOfStudent:";
$langTeacherTutorials = "Χρήσιμοι Οδηγοί $langsOfTeacher";
$langStudentTutorials = "Χρήσιμοι Οδηγοί $langsOfStudent";
$langTeacherStudentTutorials = "Χρήσιμοι Οδηγοί $langsOfTeacher - $langsOfStudent";
$langAdminTutorials = "Χρήσιμοι Οδηγοί διαχειριστή";
$langDisableModulesHelp = "Μπορείτε να επιλέξετε ποια από τα παρακάτω
    υποσυστήματα επιθυμείτε να απενεργοποιηθούν από όλες τις $langsCourses της
    πλατφόρμας.";
$langDefaultModulesHelp = "Τα παρακάτω υποσυστήματα είναι ενεργοποιημένα εξ
    ορισμού στις νέες $langsCourses της πλατφόρμας κατά τη δημιουργία τους.";
$langAutoEnrollCourse = "Αυτόματη εγγραφή σε $langsCourses";
$langAutoEnrollDepartment = "Αυτόματη εγγραφή σε όλες τις $langsCourses των τμημάτων";
$langActivityCourse = 'Συνεργασίες-Δραστηριότητες';
$langPopularCourse = "Δημοφιλή $langCourses";

// Stat
$langNbProf = "Αριθμός " . $langsOfTeachers;
$langNbStudents = "Αριθμός " . $langsOfStudents;
$langNbCourses = "Αριθμός $langsOfCourses";
$langRestoreCourse = "Ανάκτηση $langOfCourse";
$langStatCour = "Ποσοτικά στοιχεία $langsOfCourses";
$langNumCourses = "Αριθμός $langsOfCourses";
$langNumEachCourse = "Αριθμός $langsOfCourses ανά $langsFaculty";
$langNumEachLang = "Αριθμός $langsOfCourses ανά γλώσσα";
$langNunEachAccess = "Αριθμός $langsOfCourses ανά τύπο πρόσβασης";
$langNumEachCat = "Αριθμός $langsOfCourses ανά τύπο $langsOfCourses";
$langPopularCourses = "$langCourses με τους περισσότερους $langUsersS";
$langMultipleCourseUsers = "Χρήστες που είναι γραμμένοι στις περισσότερες συνεργασίες";
$langAltAuthStudentReq = "Ενεργοποίηση αίτησης $langsOfStudent που συνδέεται με εναλλακτικό τρόπο πιστοποίησης";
$langDisableEclassStudReg = "Απενεργοποίηση εγγραφής $langsOfStudent";
$langDisableEclassProfReg = "Απενεργοποίηση εγγραφής $langsOfTeacher";
$langDisableEclassStudRegType = "Δυνατότητα εγγραφής $langsOfStudents";
$langDisableEclassProfRegType = "Δυνατότητα εγγραφής $langsOfTeachers";
$langDisableEclassStudRegYes = "Τα $langsStudents δεν μπορούν να εγγραφούν μέσω πλατφόρμας";
$langDisableEclassProfRegYes = "Οι $langsTeachers δεν μπορούν να εγγραφούν μέσω πλατφόρμας";
$langDisableEclassStudRegNo = "Τα $langsStudents μπορούν να εγγραφούν μέσω πλατφόρμας";
$langDisableEclassStudRegViaReq = "Τα $langsStudents μπορούν να εγγραφούν μέσω αίτησης";
$langDisableEclassProfRegNo = "Οι $langsTeachers μπορούν να εγγραφούν μέσω αίτησης";

// listcours
$langOpenCourse = "Ανοικτή $langsCourse";
$langClosedCourse = "Κλειστή $langsCourse";
$langClosedCourses = "Κλειστες $langsCourses";
$langInactiveCourse = "Ανενεργή $langsCourse";

// quotacours
$langQuotaAdmin = "Διαχείριση Αποθηκευτικού Χώρου $langOfCourse";

// addfaculte
$langFaculteAdd = "Προσθήκη $langOfFaculty";
$langFaculteDel = "Διαγραφή $langOfFaculty";
$langFaculteEdit = "Επεξεργασία στοιχείων $langOfFaculty";
$langFaculteIns = "Εισαγωγή Στοιχείων $langOfFaculty";

// addusertocours
$langListRegisteredStudents = "Λίστα Εγγεγραμμένων " . $langOfStudents;
$langListRegisteredProfessors = "Λίστα Εγγεγραμμένων " . $langOfTeachers;
$langErrChoose = "Παρουσιάστηκε σφάλμα στην επιλογή $langsOfCourse!";
// delcours
$langCourseDel = "Διαγραφή $langsOfCourse";
$langCourseDelSuccess = "Η $langsCourse διαγράφηκε με επιτυχία!";
$langCourseDelConfirm = "Επιβεβαίωση Διαγραφής $langOfCourse";
$langCourseDelConfirm2 = "Θέλετε σίγουρα να διαγράψετε την $langsCourse";
$langNoticeDel = "ΣΗΜΕΙΩΣΗ: Η διαγραφή της $langsOfCourse θα διαγράψει επίσης τα εγγεγραμμένα " . $langsOfStudentss . " από την $langsCourse, την αντιστοιχία της $langsOfCourse στη $langsFaculty, καθώς και όλο το υλικό της $langsOfCourse.";

// editcours
$langCourseInformationText = "Επεξεργασία περιγραφής $langsOfCourse";
$langCourseEdit = "Επεξεργασία $langOfCourse";
$langCourseImage = "Φωτογραφία $langOfCourse";
$langCourseStatus = "Κατάσταση $langOfCourse";
$langStatsCourse = "Στατιστικά $langOfCourse";

// course_info.php
$langCourseEditSuccess = "Τα στοιχεία της $langsOfCourse άλλαξαν με επιτυχία!";
$langCourseInfoEdit = "Αλλαγή στοιχείων $langsOfCourse";
$langBackCourse = "Επιστροφή στην αρχική σελίδα της $langsOfCourse";
$langCourseFormat = "Mορφή $langsOfCourse";
$langWithCourseUnits = "$langCourse με ενότητες (εβδομαδιαίες, θεματικές)";
$langsCourseSharing = "διαμοιρασμού $langsOfCourse σε κοινωνικά δίκτυα";
$langsCourseRating = "αξιολόγησης $langsOfCourse";
$langCourseComment = "σχολιασμού $langsOfCourse";
$langsCourseAnonymousRating = "σχολιασμού $langsOfCourse από ανώνυμους χρήστες";
$langForumNotifications = "Ενημέρωση $langsOfStudents";
$langActivateForumNotifications = "Ενεργοποίηση ενημέρωσης $langsOfStudents (μέσω email)";
$langDisableForumNotifications = "Aπενεργοποίηση ενημέρωσης $langsOfStudents (μέσω email)";

// listreq.php
$langOpenProfessorRequests = "Ανοικτές Αιτήσεις " . $langOfTeachers;
$langProfessorRequestClosed = "Η αίτηση του " . $langsOfTeacher . " έκλεισε!";
$langemailbodyBlocked = "Η αίτησή σας για εγγραφή στην πλατφόρμα " . $siteName . " απορρίφθηκε.";

// mailtoprof.php
$langProfOnly = "στους " . $langsTeachers . " ";
$langStudentsOnly = "στα " . $langsOfStudentss . " ";

// searchcours.php
$langSearchCourse = "Αναζήτηση $langOfCourses";

// statuscours.php
$langCourseStatusChangedSuccess = "Ο τύπος πρόσβασης της $langsOfCourse άλλαξε με επιτυχία!";
$langCourseStatusChange = "Αλλαγή τύπου πρόσβασης $langsOfCourse";

// authentication
$langMultiMoveCourseInfo = "Επιλέξτε τη νέα $langsFaculty στην οποία θα μεταφερθούν οι $langsCourses.";
$langMultiRegCourseUser = "Μαζική εγγραφή χρηστών σε $langsCourses";
$langMultiMoveCourses = "Μαζική μεταφορά $langsOfCourses";
$langConfirmMultiMoveCourses = "Επιβεβαίωση μεταφοράς $langsOfCourses σε άλλο τμήμα.";
$langCourseCodes = "Κωδικοί $langsOfCourses";
$langAskManyUsersToCourses = "Οι $langsCourses θα πρέπει να υπάρχουν και οι χρήστες θα πρέπει να έχουν ήδη λογαριασμό στην πλατφόρμα για να εγγραφούν σε αυτά. Πληκτρολογήστε τα ονόματα χρήστη (usernames) και τους κωδικούς των $langsOfCourses σε ξεχωριστές γραμμές.";
$langMultiRegUserInfo = "<p>Εισαγάγετε στην παρακάτω περιοχή έναν κατάλογο με
τα στοιχεία των χρηστών, μία γραμμή ανα χρήστη που επιθυμείτε να δημιουργηθεί.
</p>
<p>Η σειρά των στοιχείων ορίζεται στο πεδίο που βρίσκεται πριν την
περιοχή, και οι δυνατές ετικέτες είναι οι εξής:</p>
<ul>
<li><tt>first</tt>: Όνομα</li>
<li><tt>last</tt>: Επώνυμο</li>
<li><tt>email</tt>: Διεύθυνση e-mail</li>
<li><tt>id</tt>: Αριθμός μητρώου</li>
<li><tt>phone</tt>: Τηλέφωνο</li>
<li><tt>username</tt>: Όνομα χρήστη</li>
<li><tt>password</tt>: Κωδικός χρήστη</li>
</ul>
<p>Αν επιθυμείτε οι χρήστες να εγγραφούν αυτόματα σε κάποιες $langsCourses, προσθέστε
τους κωδικούς τους στο τέλος της γραμμής μετά τα πεδία που έχετε ορίσει. Το
e-mail είναι προαιρετικό - αν θέλετε να το παραλείψετε, βάλτε στη θέση του μια
παύλα (-). Οι γραμμές που αρχίζουν από # αγνοούνται. Αν δεν ορίσετε το όνομα
χρήστη των χρηστών, θα πάρουν αυτόματα ονόματα χρήστη αποτελούμενα από το
πρόθεμα που μπορείτε να ορίσετε παρακάτω και έναν αύξοντα αριθμό. Αν δεν ορίσετε
το password, ορίζεται αυτόματα ένας τυχαίος κωδικός διαφορετικός για κάθε λογαριασμό</p>";
$langMultiRegCourseInvalid = "Χρήστης %s: μη έγκυρος κωδικός $langsOfCourse «%s»";
$langSearchCourses = "Αναζήτηση $langsOfCourses";

// other
$langLessonCode = "Συνθηματικό $langsOfCourse";

// unregister
$langConfirmDeleteQuestion2 = "από την $langsCourse";
$langWasCourseDeleted = "διαγράφηκε από την $langCourse";
$langErrorUnreguser = "Σφάλμα κατά την απεγγραφή του χρήστη από την $langsCourse";


// eclassconf
$langDefaultQuota = "Αποθηκευτικός χώρος νέων $langsOfCourses";
$langStudentUploadWhitelist = "Τύποι επιτρεπτών αρχείων για τα $langsOfStudentss";
$langTeacherUploadWhitelist = "Τύποι επιτρεπτών αρχείων για τους $langsTeachers";
$langIndexingRemain = "$langCourses που απομένουν για ευρετηριοποίηση";
$langReqRegUser = "Αίτηση εγγραφής $langsOfStudent";
$langCourseSettings = "Ρυθμίσεις $langsOfCourses";
$langCourseOfflineSettings = "Κατέβασμα $langsOfCourse";
$langCourseOfflineLegend = "Τα $langsStudents μπορούν να κατεβάσουν την $langsCourse στον υπολογιστή τους.";
$langUserConsent = "Συναίνεση $langsOfStudent";
$langUnsubscribeCourse = "Απενεργοποίηση απεγγραφής συνεργασίας";
$langClassInfoTitle = "Στοιχεία συνεργασίας";
$langStuNum = "Αριθμός Μελών";
$langLectNum = "Αριθμός Συνεργασιών";
$langLectHours = "Χρόνος συνεργασίας";
$langTotalHours = "Συνολικός χρόνος";
$langEmptyGoal ="Συμπληρώστε όλους τους συνεργασιακούς στόχους που έχετε δημιουργήσει.";
$langConfirmDeleteGoal = "Θέλετε σίγουρα να αφαιρέσετε το συγκεκριμένο συνεργασιακό στόχο;";


// common documents
$langExplainCommonDocs = "Το αρχείο που θα ανεβάσετε θα είναι προσβάσιμο από όλες τις $langsCourses μέσω του υποσυστήματος 'Εγγραφα'";

/* * ********************************************************
 * agenda.php
 * ******************************************************** */
$langPreviousMonth = "Προηγούμενος $langMonth";
$langNextMonth = "Επόμενος $langMonth";
$langAgendaCourseEvent = "Γεγονός $langsOfCourse";


/* * *********************************************************
 * announcements.php
 * ********************************************************** */
$langRegUser = "εγγεγραμμένους χρήστες της $langsOfCourse";
$professorMessage = "Μήνυμα $langsOfTeacher";
$langCourseAnnouncements = "Ανακοινώσεις $langsOfCourse";
$langLinkUnsubscribe = "Λάβατε αυτό το μήνυμα επειδή είστε γραμμένος στην $langsCourse '%s'. Αν δεν επιθυμείτε να σας αποστέλλονται άλλα e-mails από την συγκεκριμένη $langsCourse κάντε κλικ";
$langEmailUnsubscribe = "Ειδοποιήσεις $langsOfCourse";
$langInfoUnsubscribe = "Μπορείτε να ρυθμίσετε τη λήψη ειδοποιήσεων από τις παρακάτω $langsCourses. Αν δεν επιθυμείτε
        να δέχεστε e-mails από κάποια $langsCourse, αποεπιλέξτε το και κάντε κλικ στο 'Ύποβολή'. <br />(Σημείωση: Δεν απεγγράφεστε από την $langsCourse).";
$langEmailUnsubSuccess = "Δεν θα λαμβάνετε πλέον e-mails από την $langsCourse '%s'";
$langEmailFromCourses = "Λήψη e-mails από τις $langsCourses μου";
$langEmailUnsubscribeWarning = "Έχετε απενεργοποιήσει τη λήψη μηνυμάτων από την πλατφόρμα.
Δεν μπορείτε να ρυθμίσετε τη λήψη από συγκεκριμένες $langsCourses πριν την επανενεργοποιήσετε.";
$langAnnHasPublished = "Έχει δημοσιευθεί ανακοίνωση στην $langsCourse";

/* * *****************************************
 * archive_course.php
 * ***************************************** */
$langCreateDirCourseBase = "Δημιουργία του καταλόγου για την ανάκτηση των βάσεων των $langsOfCourses";
$langCopyDirectoryCourse = "Αντιγραφή των αρχείων της $langsOfCourse";
$langBUCourseDataOfMainBase = "Αντίγραφο ασφαλείας των δεδομένων της $langsOfCourse";
$langBackupOfDataBase = "Αντίγραφο ασφαλείας της βάσης δεδομένων της $langsOfCourse";


/* * **********************************************************
 * chat
 * **************************************************************** */
$langUntitledChat = "Ελεύθερη κουβεντούλα $langsOfCourse";

/* * ***************************************************************
 * copyright.php
 * **************************************************************** */
$langCopyright = "Πληροφορίες Πνευματικών Δικαιωμάτων";
$langUsageTerms = 'Όροι Χρήσης';

/* * *****************************************************
 * course_description.php
 * ***************************************************** */
$langCourseProgram = "Περιγραφή $langOfCourse";
$langThisCourseDescriptionIsEmpty = "Η $langsCourse δεν διαθέτει περιγραφή";
$langQuestionPlan = "Ερώτηση στον συντονιστή";

$titreBloc = array(
    "Περιεχόμενο $langsOfCourse",
    'Συνεργασιακοί στόχοι',
    'Βιβλιογραφία',
    'Μέθοδοι διδασκαλίας',
    'Μέθοδοι αξιολόγησης',
    'Προαπαιτούμενα',
    'Συντονιστές',
    'Ομάδα στόχος',
    'Προτεινόμενα συγγράμματα',
    'Περισσότερα');
$titreBlocNotEditable = array(TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, FALSE);

/* * ******************************************************
 * course_home.php
 * ******************************************************* */
$langIdentity = "Ταυτότητα $langOfCourse";
$langCourseS = $langsCourse;
$langCitation = "Βιβλιογραφική αναφορά $langsOfCourse";
$langUserEmailNotification = "Λαμβάνετε ειδοποιήσεις της $langsOfCourse μέσω email.";
$langNoUserEmailNotification = "Δεν λαμβάνετε ειδοποιήσεις της $langsOfCourse μέσω email.";
$langNoUserEmailLegend = "Ο χρήστης δεν λαμβάνει ειδοποιήσεις της $langsOfCourse μέσω email.";
$langCourseInvalidDepartment = "Η $langsCourse βρίσκεται σε τμήμα όπου δεν
    επιτρέπεται πλέον η δημιουργία $langsOfCourses.";
$langCourseInvalidDepartmentPrompt = "Παρακαλούμε %s μεταφέρετέ το
    μέσω των ρυθμίσεων $langsOfCourse %s.";
$langReadMore = "Περισσότερα";
$langReadLess = "Λιγότερα";
$langNoInfoAvailable = "Δεν υπάρχουν διαθέσιμες πληροφορίες";
$langDownloadCourse = "Κατέβασμα της συνεργασίας";
$langConfEnableMailNotification = "Θέλετε να ενεργοποιήσετε τη λήψη ειδοποιήσεων της $langsOfCourse μέσω email;";
$langConfDisableMailNotification = "Θέλετε να απενεργοποιήσετε τη λήψη ειδοποιήσεων της $langsOfCourse μέσω email;";
$langOfNotifications = "ειδοποιήσεων";


/* * *******************************************
 * course_info.php
 * ******************************************* */
$langCourseIden = "Ταυτότητα $langOfCourse";
$langCloneCourse = "Κλώνος $langsOfCourse";
$langModifDone = "Οι ρυθμίσεις της $langsOfCourse άλλαξαν.";
$langDelCourse = "Διαγραφή της $langsOfCourse";
$langCourseTitle = "Τίτλος $langOfCourse";
$langConfTip = "Επιλέξτε τον τύπο πρόσβασης της $langsOfCourse από τους χρήστες.";
$langNoCourseTitle = "Δεν πληκτρολογήσατε τον τίτλο της $langsOfCourse";
$langCourseWeeklyFormatNotice = "Για εβδομαδιαία απεικόνιση πρέπει να επιλέξετε τουλάχιστον την ημερομηνία έναρξης $langsOfCourse";
$langCourseUserRequests = "Αιτήσεις εγγραφής χρηστών στην $langsCourse";
$langCourseUserRequestsDisabled = "Αιτήσεις εγγραφής χρηστών δεν υπάρχουν για τις μη κλειστές $langsCourses.";
$langUsersListAccess = "Εμφάνιση χρηστών της $langsOfCourse";
$langUsersListAccessInfo = "αφορά μόνο τους εγγεγραμμένους χρήστες της $langsOfCourse";

// delete_course.php
$langTheCourse = "Η $langsCourse";
$langHasDel = "έχει διαγραφεί";
$langByDel = "Διαγράφοντας την $langsCourse θα διαγράψετε μόνιμα όλα τα περιεχόμενά του και όλα τα " . $langsOfStudentss . " που είναι γραμμένοι σε αυτή (δεν θα διαγραφούν από τις άλλες $langsCourses).";
$langByDel_A = "Θέλετε πράγματι να διαγράψετε την $langsCourse:";
$langTipLang = "Επιλέξτε την γλώσσα στην οποία θα εμφανίζονται τα μηνύματα της $langsOfCourse.";

// deluser_course.php
$langConfirmDel = "Επιβεβαίωση διαγραφής $langsOfCourse";
$langUserDel = "Πρόκειται να διαγράψετε όλα τα " . $langsOfStudentss . " από την $langsCourse (δεν θα διαγραφούν από τις άλλες $langsCourses).<p>Θέλετε πράγματι να προχωρήσετε στη διαγραφή τους από την $langsCourse;";

// refresh course.php
$langRefreshCourse = "Ανανέωση $langsOfCourse";
$langRefreshInfo = "Προκειμένου να προετοιμάσετε την $langsCourse για μια νέα ομάδα " . $langsOfStudents . " μπορείτε να διαγράψετε το παλιό περιεχόμενο.";
$langRefreshInfo_A = "Επιλέξτε ποιες ενέργειες θέλετε να πραγματοποιηθούν.";
$langUserDelCourse = "Διαγραφή χρηστών από την $langsCourse";
$langUserDelNotice = "Σημ.: Οι χρήστες δεν θα διαγραφούν από άλλες $langsCourses";
$langAnnouncesDel = "Διαγραφή ανακοινώσεων της $langsOfCourse";
$langAgendaDel = "Διαγραφή εγγραφών από το ημερολόγιο της $langsOfCourse";
$langHideDocuments = "Απόκρυψη των εγγράφων της $langsOfCourse";
$langHideWork = "Απόκρυψη των εργασιών της $langsOfCourse";
$langHideExercises = "Απόκρυψη των ασκήσεων της $langsOfCourse";
$langDelAllWorkSubs = "Διαγραφή των υποβολών των εργασιών της $langsOfCourse";
$langDelWallPosts = "Διαγραφή αναρτήσεων τοίχου της $langsOfCourse";
$langDelBlogPosts = "Διαγραφή αναρτήσεων ιστολογίου της $langsOfCourse";
$langRefreshSuccess = "Η ανανέωση της $langsOfCourse ήταν επιτυχής. Εκτελέστηκαν οι ακόλουθες ενέργειες:";
$langUsersDeleted = "Οι χρήστες διαγράφηκαν από την $langsCourse";
$langAnnDeleted = "Οι ανακοινώσεις διαγράφηκαν από την $langsCourse";
$langAgendaDeleted = "Οι εγγραφές του ημερολογίου διαγράφτηκαν από την $langsCourse";
$langBlogPostsDeleted = "Οι αναρτήσεις του ιστολογίου διαγράφηκαν από την $langsCourse";
$langWallPostsDeleted = "Οι αναρτήσεις του τοίχου διαγράφηκαν από την $langsCourse";


/* * ***************************************************
 * contact.php
 * **************************************************** */
$langContactProf = "Επικοινωνία με τους $langsTeachers";
$langEmailEmpty = "Η διεύθυνση ηλεκτρονικού ταχυδρομείου σας είναι κενή.
Για να μπορείτε να επικοινωνήσετε με τον $langsOfTeacher, θα πρέπει να έχετε ορίσει
τη διεύθυνσή σας, ώστε να μπορείτε να λάβετε απάντηση. Μπορείτε να ορίσετε τη
διεύθυνσή σας από την επιλογή <a href='%s'>«Αλλαγή του προφίλ μου»</a> στη
σελίδα του χαρτοφυλακίου σας.";

$langContactMessage = "Πληκτρολογήστε το κείμενο του μηνύματός σας. Αυτό θα σταλεί μεσω email στους υπεύθυνους $langsTeachers της $langsOfCourse.";
$langSendingMessage = "Η αίτηση στάλθηκε στους $langsTeachers της $langsOfCourse:";
$langContactIntro = "Ο χρήστης της πλατφόρμας $siteName με όνομα %s (%s <%s>) σας έστειλε την παρακάτω αίτηση εγγραφής.";
$langContactIntroFooter = "Για να διαχειριστείτε τις αιτήσεις εγγραφής στην $langsCourse κάντε κλικ ";

$langNonUserContact = "Για να επικοινωνήσετε με τους υπεύθυνους $langsTeachers
της $langsOfCourse, θα πρέπει να έχετε λογαριασμό στο σύστημα και
να έχετε συνδεθεί. Παρακαλούμε επισκεφθείτε την <a href='%s'>αρχική σελίδα</a>.";
$langInfoAboutRegistration = "Η $langsCourse που επιλέξατε είναι κλειστή. Για να εγγραφείτε, θα πρέπει
να συμπληρώσετε την παρακάτω αίτηση, η οποία θα καταγραφεί και θα αποσταλεί στους διαχειριστές της $langsOfCourse.";
$langLabelCourseUserRequest = "Αίτηση εγγραφής στην $langsCourse";
$langRequestReasons = "Αναφέρετε τους λόγους που επιθυμείτε την εγγραφή σας στην $langsCourse.";

/* * **************************************************
 * create_course.php
 * *************************************************** */
$langDescrInfo = "Σύντομη περιγραφή της $langsOfCourse";
$langTargetFac = "Η $langsFaculty στην οποία υπάγεται την $langsCourse";
$langDoubt = "Αν δεν ξέρετε το κωδικό της $langsOfCourse συμβουλευτείτε";
$langExFac = "* Αν επιθυμείτε να δημιουργήσετε $langsCourse σε άλλη $langsFaculty από αυτή που ανήκετε, τότε επικοινωνήστε με
την Ομάδα Ασύγχρονης Τηλεκπαίδευσης";
$langErrorDir = "Ο υποκατάλογος της $langsOfCourse δεν δημιουργήθηκε και η $langsCourse δεν θα λειτουργήσει!<br><br>Ελέγξτε τα δικαιώματα πρόσβασης του καταλόγου <em>courses</em>.";
$langSubsystems = "Επιλέξτε τα υποσυστήματα που θέλετε να ενεργοποιήσετε για το νέα σας $langsCourse:";
$langLanguageTip = "Επιλέξτε σε ποια γλώσσα θα εμφανίζονται οι σελίδες της $langsOfCourse";
$langDelAdmin = "Περιοχή συζητήσεων για κάθε θέμα που αφορά την $langsCourse";
$langVideoLinks = "Βιντεοσκοπημένες $langCourses";
$langModifyInfo = "Διαχείριση $langOfCourse";
$langVideoText = "Παράδειγμα ενός αρχείου RealVideo. Μπορείτε να ανεβάσετε οποιοδήποτε τύπο αρχείου ήχου ή βίντεο (.mov, .rm, .mpeg...), εφόσον τα " . $langsStudents . " έχουν το αντίστοιχο plug-in για να το δούν";
$langIntroductionText = "Εισαγωγικό κείμενο της $langsOfCourse. Αντικαταστήστε το με το δικό σας, κάνοντας κλίκ στην <strong>Αλλαγή</strong>.";
$langJustCreated = "Μόλις δημιουργήσατε με επιτυχία την $langsCourse με τίτλο ";
$langCreateCourseNotAllowedNode = "Επιλέξατε μη επιτρεπτές $langsFaculties. Παρακαλώ ξαναπροσπαθήστε.";


$langAttendanceAbsencesFrom2 = "υποχρεωτικές της $langsOfCourse.";
$langAttendanceUsers = "Επιτυχής ενημέρωση αριθμού $langsOfStudents.";
$langAttendanceActCour = "Δραστηριότητα $langsOfCourse";
$langAttendance6Months = "Συμμετέχουν τα $langsStudents τελευταίου εξαμήνου";
$langAttendance3Months = "Συμμετέχουν τα $langsStudents τελευταίου τριμήνου";
$langAttendanceAllMonths = "Συμμετέχουν όλα τα εγγεγραμμένα $langsStudents";
$langNewAttendance2 = "Δημιουργία νέου παρουσιολογίου για την $langsCourse";


$langGradebookActCour = "Δραστηριότητα $langsOfCourse";
$langGradebookAllBetweenRegDates = "Όλοι όσοι έχουν εγγραφεί στην $langsCourse το παρακάτω χρονικό διάστημα";
$langGradebookAssignSpecific = "Η εργασία αφορά συγκεκριμένα $langsStudents";
$langStudLastSemester = "$langStudents μόνο τελευταίου τριμήνου";
$langNoRegStudent = "Δεν υπάρχουν $langsStudents που συμμετέχουν στο βαθμολόγιο. Μπορείτε να προσθέσετε χρήστες κάνοντας κλικ";
$langNoStudents = "Δεν υπάρχουν $langsStudents στο διάστημα που επιλέξατε";
$langNoStudentsInAttendance = "Δεν υπάρχουν $langsStudents στο παρουσιολόγιο.  Μπορείτε να προσθέσετε χρήστες κάνοντας κλικ";
$langUsersGradebook = "$langStudents βαθμολογίου";
$langNoGradebook = "Δεν συμμετέχετε σε $langsCourses με βαθμολόγηση.";
$langNewGradebook2 = "Δημιουργία νέου βαθμολογίου για την $langsCourse";
$langChangeGradebook2 = "(επιλογή ενεργού βαθμολογίου για την $langsCourse)";
$langSpecificUsers = "συγκεκριμένα $langsStudents";



// Groups
$langGroupManyUsers = "<strong>Σημείωση</strong>: Οι χρήστες θα πρέπει να είναι ήδη εγγεγραμμένοι στην $langsCourse.";
$langUsersNotRegistered = "Οι παρακάτω χρήστες δεν έχουν εγγραφεί στην $langsCourse";

//neos odhgos dhmiourgias mathimaton
$langEnterMetadata = "Μπορείτε να αλλάξετε τις ρυθμίσεις της $langsOfCourse μέσα από τη 'Διαχείριση $langOfCourse'";
$langCreateCourse = "Οδηγός δημιουργίας $langsOfCourse";
$langCreateCourseStep2Title = "Συμπληρωματικές πληροφορίες $langsOfCourse";
$langcourse_objectives = "Στόχοι της $langsOfCourse";
$langFinalize = "Δημιουργία $langsOfCourse";
$langCourseCategory = "Η κατηγορία στην οποία ανήκει η $langsCourse";
$langProfessorsInfo = "Ονοματεπώνυμα $langsOfTeachers της $langsOfCourse χωρισμένα με κόμματα (π.χ.<i>Νίκος Τζικόπουλος, Κώστας Αδαμόπουλος</i>)";
$langClosedCourseShort = "Πρόσβαση στην $langsCourse έχουν μόνο όσοι βρίσκονται στη Λίστα Χρηστών της $langsOfCourse";
$langCourseInactive= "Πρόσβαση στην $langsCourse έχουν μόνο οι $langsTeachers της $langsOfCourse";
$langCourseInactiveShort = "Ανενεργές $langsCourses";
$langCourseActiveShort = "Ενεργές $langsCourses";
$langAlertTitle = "Παρακαλώ συμπληρώστε τον τίτλο της $langsOfCourse!";
$langAlertProf = "Παρακαλώ συμπληρώστε τον συντονιστή της $langsOfCourse!";

// Admin mutiple course creation
$langMultiCourse = "Μαζική δημιουργία $langsOfCourses";
$langMultiCourseInfo = "Εισαγάγετε στην παρακάτω περιοχή μια λίστα με τους
τίτλους των $langsOfCourses που επιθυμείτε να δημιουργηθούν, με τον κάθε
τίτλο σε ξεχωριστή γραμμή. Αν επιθυμείτε να προστεθεί αυτόματα
συντονιστής στην $langsCourse, σημπληρώστε το ονοματεπώνυμο ή το όνομα χρήστη
του μετά τον τίτλο, διαχωρισμένο με το χαρακτήρα \"|\".";
$langMultiCourseTitles = "Τίτλοι / Συντονιστές $langOfCourses";
$langMultiCourseData = "Στοιχεία $langOfCourses";
$langMultiCourseCreated = "η $langsCourse δημιουργήθηκε";



/* * ***********************************************
 * dropbox.php
 * *********************************************** */
$langNewPersoMessage = "Νέο προσωπικό μήνυμα";
$langNewCourseMessage = "Νέο μήνυμα $langsOfCourse";
$langBadFormData = "Η αποστολή του αρχείου απέτυχε";
$langDropBoxIncompatible = "Προσοχή! Το υποσύστημα 'Ανταλλαγής Αρχείων' πιθανόν
    να μην έχει ανακτηθεί σωστά λόγω ασυμβατότητας. Ελέγξτε τα id του πίνακα
    dropbox_file στη βάση της $langsOfCourse.";
$langDropboxFreeSpaceConfirm = "Αυτή η ενέργεια θα διαγράψει τα συνημμένα αρχεία στα παλαιότερα μηνύματα της $langsOfCourse ώστε να απελευθερωθεί χώρος %s! Οι χρήστες δε θα μπορούν πλέον να τα κατεβάσουν!";




/* * *********************************************
 * faculty.php
 * ********************************************* */
$langCodeFaculte1 = "Κωδικός $langOfFaculty";
$langAddFaculte = "Προσθήκη $langOfFaculties";
$langProErase = "Υπάρχουν διδασκόμενες $langsCourses!";
$langNoErase = "Η διαγραφή του $langOfFaculty δεν είναι δυνατή.";

/* * *********************************************
 * hierarchy.php
 * ********************************************* */

$langHierarchyActions = "Κατάλογος $langOfFaculties - Ενέργειες";
$langNodeAdd = "Επιλογή $langOfFaculty";
$langNodeDel = "Διαγραφή $langOfFaculty";
$langNodeEdit = "Επεξεργασία $langOfFaculty";
$langNodeCode1 = "Κωδικός $langOfFaculty";
$langNodeName = "Όνομα $langOfFaculty";
$langNodeDescription = "Περιγραφή $langOfFaculty";
$langNodeParent2 = "(στην οποία θα ανήκει η $langsFaculty που επεξεργάζεστε)";
$langNodeAllowCourse = "Εγγραφή $langsOfCourses";
$langNodeAllowCourse2 = "(έλεγχος αν θα μπορούν να ανήκουν $langsCourses στη $langsFaculty)";
$langNodeAllowUser = "Εγγραφή χρηστών";
$langNodeAllowUser2 = "(έλεγχος αν θα μπορούν να ανήκουν χρήστες στη $langsFaculty)";
$langNodePublic2 = "Η $langsFaculty θα εμφανίζεται για όλους τους χρήστες";
$langNodeSubscribed2 = "Η $langsFaculty θα εμφανίζεται μόνο για τους εγγεγραμμένους σε αυτήν χρήστες";
$langNodeHidden2 = "Η $langsFaculty θα παραμένει κρυμμένη από όλους τους χρήστες";
$langNodeProErase = "Υπάρχουν $langsCourses ή χρήστες που ανήκουν σε αυτόν τον κόμβο ($langsFaculty) ή στα παιδιά του!";
$langNodeNoErase = "Η διαγραφή της $langsOfFaculty δεν είναι δυνατή.";
$langNodeErase = "Η $langsFaculty διαγράφηκε!";
$langReturnToEditNode = "Επιστροφή στην επεξεργασία $langsOfFaculty";

/* * *************************************************************
 * grades.php
 * ************************************************************** */
$m['grades'] = "Βαθμολογία";

/* * ***********************************************************
 * group
 * *********************************************************** */


// Group Properties
$langGroupAllowStudentRegistration = "Τα " . $langsStudents . " επιτρέπεται να εγγραφούν";
$langGroupAllowStudentUnregister = "Τα " . $langsStudents . " επιτρέπεται να απεγγραφούν";


// Group space
$langNoGroupStudents = "Μη εγγεγραμμένα " . $langsStudents . " ";
$langGroupNoneMasc = "Δεν υπάρχουν $langsStudents στην ομάδα";
$langGroupFilledGroups = "Οι ομάδες χρηστών έχουν συμπληρωθεί από " . $langsOfStudentss . " που βρίσκονται στον κατάλογο «Χρήστες».";

// group - email
$langProfLesson = "Συντονιστής της $langsOfCourse";

/* * ***************************************************
 * guest.php
 * *************************************************** */

$langGuestSurname = "$langOfCourse";
$langGuestLoginLabel = "Λογαριασμοί επισκεπτών $langsOfCourses";
$langGuestLoginLinks = "Ενεργοποίηση και προσθήκη συνδέσμων στον κατάλογο $langsOfCourses";

/* * ******************************************************
 * gunet.php
 * ****************************************************** */
$infoprof = "Σύντομα θα σας σταλεί e-mail από την Ομάδα Διαχείρισης της Πλατφόρμας Ασύγχρονης Τηλεκπαίδευσης $siteName, με τα στοιχεία του λογαριασμού σας.";
$profinfo = "Η ηλεκτρονική πλατφόρμα $siteName διαθέτει 2 εναλλακτικούς τρόπους εγγραφής συντονιστών";
$userinfo = "Η ηλεκτρονική πλατφόρμα $siteName διαθέτει 2 εναλλακτικούς τρόπους εγγραφής χρηστών:";
$regprofldap = "Εγγραφή συντονιστών που έχουν λογαριασμό στην Υπηρεσία Καταλόγου (LDAP Directory Service) του ιδρύματος που ανήκουν";
$regldap = "Εγγραφή χρηστών που έχουν λογαριασμό στην Υπηρεσία Καταλόγου (LDAP Directory Service) του ιδρύματος που ανήκουν";
$regprofnoldap = "Εγγραφή συντονιστών που δεν έχουν λογαριασμό στην Υπηρεσία Καταλόγου του ιδρύματος που ανήκουν";
$regnoldap = "Εγγραφή χρηστών που δεν έχουν λογαριασμό στην Υπηρεσία Καταλόγου του ιδρύματος που ανήκουν";
$mailbody1 = "\n$Institution\n\n";
$mailbody5 = "του $siteName ";
$mailbody6 = "ως $langTeacher.";
$mailbody8 = "ως $langStudent.";
$logo = "Πλατφόρμα Ασύγχρονης Τηλεκπαίδευσης $siteName";
$gunet = "Ομάδα Ασύγχρονης Τηλεκπαίδευσης $siteName";
$langAdminMessage = "Μήνυμα Διαχειριστή $siteName";

// contact.php
$introcontact = "Μπορείτε να επικοινωνείτε με την Ομάδα Υποστήριξης της πλατφόρμας <strong>" . $siteName . "</strong> με τους παρακάτω τρόπους:";


/* * **********************************************************
 * course_tools.php
 * ********************************************************** */

$langExplanation_0 = "Αν έχετε  δημιουργήσει κάποια σελίδα για την $langsCourse σας σε μορφή HTML (π.χ. \"my_page.htm\"), τότε μπορείτε να χρησιμοποιήσετε την παρακάτω φόρμα για να κατασκευάσετε έναν σύνδεσμο στο μενού της $langsOfCourse (αριστερά). Η σελίδα σας με αυτό τον τρόπο  δημοσιεύεται (ανεβαίνει) στην πλατφόρμα και εμφανίζεται μαζί με τα υπόλοιπα εργαλεία της $langsOfCourse. <br/>";

/* * *************************************************************
 * php
 * ************************************************************* */
$langInvalidGuestAccount = "Η $langsCourse για το οποία έχει δημιουργηθεί ο λογαριασμός 'χρήστη επισκέπτη' δεν υπάρχει πλέον.";
$langAccountActivateMessage = 'Ο χρήστης με τα παρακάτω στοιχεία επιθυμεί την
επανενεργοποίηση του λογαριασμού του:';
$langMyCoursesProf = "Οι $langsCourses που υποστηρίζω";
$langMyCoursesUser = "Οι $langsCourses που παρακολουθώ";
$langNoCourses = "Δεν υπάρχουν $langsCourses";
$langCourseCreate = "Δημιουργία $langsOfCourse";
$langListCourses = "$langCourses";
$langHierarchy = "Ιεραρχία $langOfFaculties";
$langUnregCourse = "Απεγγραφή από $langsCourse";
$langCourseCode = "$langCourse (Κωδικός)";
$langWelcomeStud = "Επιλέξτε «<strong>$langListCourses</strong>» για να παρακολουθήσετε τις διαθέσιμες ηλεκτρονικές $langsCourses.";
$langWelcomeProf = "Επιλέξτε «<strong>$langCourseCreate<strong>» για να δημιουργήσετε τις ηλεκτρονικές σας $langsCourses.";
$langWelcomeStudPerso = "«<strong>$langListCourses</strong>» για να παρακολουθήσετε τις διαθέσιμες ηλεκτρονικές $langsCourses.";
$langWelcomeProfPerso = "«<strong>$langCourseCreate</strong>» για να δημιουργήσετε τις ηλεκτρονικές σας $langsCourses.";
$langCourseOptions = "Επιλογές $langOfCourse";

/* * *********************************************************
 * install.php
 * ********************************************************* */

$langWarnHelpDesk = "Προσοχή: στο \"Email Helpdesk\" στέλνονται οι αιτήσεις συντονιστών για λογαριασμό στην πλατφόρμα";
$lang_max_glossary_terms = "Δεν επιτρέπεται η εμφάνιση ορισμών όρων στις σελίδες $langsOfCourses, εφόσον ο συνολικός αριθμός όρων στο γλωσσάριο είναι μεγαλύτερος από:";
$lang_email_required = "Να είναι υποχρεωτικό το email του $langOfUserS";
$lang_email_verification_required = "Να είναι υποχρεωτική η επιβεβαίωση του e-mail του $langOfUserS";
$lang_dont_mail_unverified_mails = "Να μην γίνεται αποστολή e-mail σε $langUsersS που δεν έχουν επιβεβαιώσει την ηλεκτρονική τους διεύθυνση";
$lang_am_required = "Να είναι υποχρεωτικός ο αριθμός μητρώου του $langsOfStudent κατά την εγγραφή";
$lang_dropbox_allow_student_to_student = "Να επιτρέπεται η ανταλλαγή μηνυμάτων $langsOfCourse μεταξύ $langsOfStudents στο υποσύστημα 'Ανταλλαγή Μηνυμάτων'";
$lang_course_multidep = "Να επιτρέπεται οι $langsCourses να ανήκουν σε πολλές $langsFaculties";
$lang_user_multidep = "Να επιτρέπεται η εγγραφή χρηστών σε πολλές $langsFaculties";
$lang_restrict_owndep = "Να μην επιτρέπεται η αλλαγή τμήματος από τους χρήστες";
$lang_restrict_teacher_owndep = "Να μην επιτρέπεται η δημιουργία $langsOfCourses από τους $langsTeachers στα τμήματα που δεν ανήκουν";
$lang_allow_teacher_clone_course = "Να επιτρέπεται η κλωνοποίηση $langsOfCourses από τους $langsTeachers";
$lang_disable_log_course_actions = "Απενεργοποίηση καταγραφής ενεργειών χρηστών μέσα στις $langsCourses";
$lang_disable_log_system_actions = "Απενεργοποίηση καταγραφής ενεργειών χρηστών εκτός $langsOfCourses";
$lang_course_metadata = "Μετασχολιασμός $langOfCourses";


/* * ***********************************************
 * lessontools.php
 * ************************************************ */
$langAdministrationTools = "Διαχείριση $langsOfCourse";
$langCourseTools = "Εργαλεία $langsOfCourse";

/* * ************************************************
 * link.php
 * ************************************************* */


/* * ***************************************************************
 * lostpass.php
 * *************************************************************** */

$langPassResetIntro = "
Έχει ζητηθεί να οριστεί νέο συνθηματικό πρόσβασης σας στην
πλατφόρμα τηλεκπαίδευσης $siteName.";
$langAccountNotFound3 = "δίνοντας τα στοιχεία σας όπως ονοματεπώνυμο, διεύθυνση email, $langsFaculty, κ.λπ.";


/* * ****************************************************
 * manual.php
 * ***************************************************** */
$langFinalDesc = "Αναλυτική Περιγραφή $siteName";
$langShortDesc = "Σύντομη Περιγραφή $siteName";
$langManS = "Εγχειρίδιο $langOfStudent";
$langManT = "Εγχειρίδιο $langOfTeacher";
$langIntroToCourse = "Γνωριμία με την Ηλεκτρονική $langCourse";
$langAdministratorCourse = "Διαχείριση Ηλεκτρονικής $langOfCourse";

/* * *******************************************************
 * open course.php
 * ******************************************************* */
$langSelectFac = "Επιλογή $langOfFaculty";
$langDepartmentsList = "Ακολουθεί ο κατάλογος τμημάτων του ιδρύματος.
	Επιλέξτε οποιοδήποτε από αυτά για να δείτε τις διαθέσιμες σε αυτό $langsCourses.";
$langWrongPassCourse = "Λάθος συνθηματικό για την $langsCourse";
$langAvCourses = "διαθέσιμες $langsCourses";
$langAvCours = "διαθέσιμη $langsCourse";
$m['open'] = "Ανοικτές $langsCourses (Ελεύθερη Πρόσβαση)";
$m['closed'] = "Κλειστές $langsCourses";
$m['nolessons'] = 'Δεν υπάρχουν διαθέσιμες '.$langsCourses.'!';
$langNoCourses = "Δεν υπάρχουν διαθέσιμες $langsCourses στην συγκεκριμένη κατηγορία!";
$m['code'] = "Συνθηματικό $langsOfCourse";
$m['mailprof'] = "Για να εγγραφείτε στην $langsCourse θα πρέπει να στείλετε mail στον διδάσκοντα της $langsOfCourse
κάνοντας κλικ";
$m['here'] = " εδώ.";
$m['unsub'] = "η $langsCourse είναι κλειστό και δεν θα μπορέσετε να επανεγγραφείτε.";

$langNotEnrolledToLessons = "Δεν έχετε εγγραφεί σε $langsCourses";

/* * *********************************************************
 * forum.php
 * ********************************************************** */

$langBodyForumNotify = "Ένα νέο θέμα έχει προστεθεί στην $langsCourse";
$langAnonymousExplain = "Οι χρήστες που εμφανίζονται με διαφορετικό χρώμα δεν είναι αυτή τη στιγμή εγγεγραμμένοι στην $langsCourse, ενώ όσοι έχουν την ένδειξη «Ανώνυμος» έχουν διαγραφεί από το σύστημα.";
$langPrivateNotice = "$langPrivateForum<br>Σημείωση: πρέπει να έχετε ενεργοποιημένα τα cookies για να χρησιμοποιήσετε προσωπικές περιοχές.";

/* * ***************************************************************
 * questionnaire.php
 * **************************************************************** */
$langCreateSurvey = 'Δημιουργία Έρευνας Συνεργασιακού Προφίλ';
$langSurveysActive = "Ενεργές Έρευνες Συνεργασιακού Προφίλ";
$langSurveysInactive = "Ανενεργές Έρευνες Συνεργασιακού Προφίλ";
$langSurveyCreated = "Η Έρευνα Συνεργασιακού Προφίλ δημιουργήθηκε με επιτυχία.";
$langSurveyDeleted = "Η Έρευνα Συνεργασιακού Προφίλ διαγράφηκε με επιτυχία.";
$langSurveyDeactivated = "Η Έρευνα Συνεργασιακού Προφίλ απενεργοποιήθηκε με επιτυχία.";
$langSurveyActivated = "Η Έρευνα Συνεργασιακού Προφίλ ενεργοποιήθηκε με επιτυχία.";
$langSurveyNone = "Δεν έχουν δημιουργηθεί έρευνες Συνεργασιακού προφίλ για την $langsCourse";
$langSurveyInactive = "Η Έρευνα Συνεργασιακού Προφίλ έχει λήξει ή δεν έχει ενεργοποιηθεί ακόμα.";
$langCurrentCourse = "Τρέχον $langCourse";

//COLLES survey
$qcolles7 = "Σε αυτή την ενότητα σκέφτομαι κριτικά για τις ιδέες των άλλων μελών";
$qcolles9 = "Σε αυτή την ενότητα εξηγώ τις ιδέες μου στα άλλα μέλη";
$qcolles10 = "Σε αυτή την ενότητα ρωτώ άλλα μέλη να εξηγήσουν τις ιδέες τους";
$qcolles11 = "Σε αυτή την ενότητα άλλα μέλη μου ζητούν να εξηγήσω τις ιδέες μου";
$qcolles12 = "Σε αυτή την ενότητα άλλα μέλη απαντούν στις ιδέες μου";
$qcolles13 = "Σε αυτή την ενότητα ο συντονιστής διεγείρει τη σκέψη μου";
$qcolles14 = "Σε αυτή την ενότητα ο συντονιστής με ενθαρρύνει να συμμετέχω";
$qcolles15 = "Σε αυτή την ενότητα ο συντονιστής προβάλει τη σωστή συζήτηση";
$qcolles16 = "Σε αυτή την ενότητα ο συντονιστής προβάλει την κριτική θεώρηση του εαυτού μας";
$qcolles17 = "Σε αυτή την ενότητα τα άλλα μέλη ενθαρρύνουν τη συμμετοχή μου";
$qcolles18 = "Σε αυτή την ενότητα τα άλλα μέλη επαινούν τη συνεισφορά μου";
$qcolles19 = "Σε αυτή την ενότητα τα άλλα μέλη εκτιμούν τη συνεισφορά μου";
$qcolles20 = "Σε αυτή την ενότητα τα άλλα μέλη κατανοούν την προσπάθειά μου για συνεργασία";
$qcolles21 = "Σε αυτή την ενότητα βγάζω νόημα από τα μηνύματα των άλλων χρηστών";
$qcolles22 = "Σε αυτή την ενότητα τα άλλα μέλη κατανοούν τα μηνύματά μου";
$qcolles23 = "Σε αυτή την ενότητα κατανοώ τα μηνύματα του συντονιστή";
$qcolles24 = "Σε αυτή την ενότητα ο συντονιστής κατανοεί τα μηνύματά μου";
$lcolles4 = "Υποστήριξη συντονιστή";
$lcolles5 = "Υποστήριξη μελών";
$scolles7 = "κριτική για τις ιδέες άλλων χρηστών";
$scolles13 = "ο συντονονιστής διεγείρει τη σκέψη μου";
$scolles14 = "ο συντονονιστής ενθαρρύνει τη συμμετοχή μου";
$scolles15 = "ο συντονονιστής προβάλει τη σωστή συζήτηση";
$scolles16 = "ο συντονονιστής προβάλει την κριτική θεώρηση του εαυτού μας";
$scolles17 = "τα άλλα μέλη ενθαρρύνουν τη συμμετοχή μου";
$scolles18 = "τα άλλα μέλη επαινούν τη συνεισφορά μου";
$scolles19 = "τα άλλα μέλη εκτιμούν τη συνεισφορά μου";
$scolles20 = "τα άλλα μέλη κατανοούν την προσπάθειά μου για συνεργασία";
$scolles21 = "βγάζω νόημα από τα μηνύματα των άλλων χρηστών";
$scolles22 = "τα άλλα μέλη κατανοούν τα μηνύματά μου";
$scolles23 = "κατανοώ τα μηνύματα του συντονιστή";
$scolles24 = "ο συντονιστής κατανοεί τα μηνύματά μου";

$colles_desc = "Το ερωτηματολόγιο COLLES (Constructive On Line Learning Environment Survey) χρησιμοποιείται για να διερευνηθούν οι απόψεις για το συνεργασιακό περιβάλλον που
				έχουν διαμορφώσει οι συμμετέχοντες. Aποτελείται από 24 ερωτήσεις. Κάθε ερώτηση έχει ως απάντηση έναν αριθμό από το 1 (Σχεδόν Ποτέ),
				2 (Σπάνια), 3 (Μερικές φορές), 4 (Συχνά), μέχρι το 5 (Σχεδόν πάντα)";
$langCollesLegend = "1 (Σχεδόν Ποτέ), 2 (Σπάνια), 3 (Μερικές φορές), 4 (Συχνά), 5 (Σχεδόν πάντα)";
$colles_detail_answer = "Εδώ μπορείτε να δείτε συγκεντρωτικά τι απάντησε ο χρήστης";

//ATTLS survey
$question4 = "Το πιο σημαντικό μέρος της συνεργασίας μου είναι να μάθω να καταλαβαίνω τους ανθρώπους οι οποίοι είναι πολύ διαφορετικοί από εμένα";
$langCKW = "Ο χρήστης μαθαίνει συνδεδεμένα με τους άλλα μέλη: ";
$langSKW = "Ο χρήστης μαθαίνει διαχωρισμένα από τα άλλα μέλη: ";
$langCKW_SKW = "Ο χρήστης μαθαίνει τόσο συνδεδεμένα όσο και διαχωρισμένα από τα άλλα μέλη: ";
$lang_ckw_skw_chart = "Εδώ παρουσιάζονται συνοπτικά πόσοι χρήστες μαθαίνουν συνδεδεμένα, πόσοι διαχωρισμένα και πόσοι και με τους δύο τρόπους";

// polls
$langPollShowResults = "Εμφάνιση αποτελεσμάτων στα $langsOfStudentss";
$langActivateMulSubmissions = "Ενεργοποίηση πολλαπλών υποβολών από τους $langsOfStudentss";


/* * **********************************************************
 * registration.php
 * *********************************************************** */

$langCourseName = "Τίτλος $langOfCourse";
$langNoCoursesAvailable = "Δεν υπάρχουν διαθέσιμες $langsCourses";
$langUserDetails = "Εγγραφή $langOfStudent";
$langPersonalSettingsMore2 = "να επιλέξετε από την επιλογή '$langCourses' τις $langsCourses που επιθυμείτε να παρακολουθήσετε.";
$langYourRegTo = "Ο κατάλογος $langsOfCourses σας περιέχει";
$langLessonName = "Όνομα $langsOfCourse";

// profile.php
$langProfileInfoProfs = "εμφάνιση στους $langsTeachers";
$langSumCoursesEnrolled = "$langCourses που παρακολουθώ";
$langSumCoursesSupport = "$langCourses που υποστηρίζω";
$langShowSettingsInfo = "αφορά την εμφάνιση στους υπόλοιπους χρήστες (εκτός των $langsOfTeachers)";

// user.php
$langInC = "σε αυτή την $langsCourse";
$langRegYou = "σας έχει εγγράψει στην $langsCourse";
$langUserDeleted = "Ο χρήστης διαγράφηκε από την $langsCourse";
$langAddHereSomeCourses = "<p>Για να εγγραφείτε / απεγγραφείτε σε / από μία $langsCourse,
πρώτα επιλέξτε τη $langsFaculty που βρίσκεστε και στη συνέχεια επιλέξτε / αποεπιλέξτε την $langsCourse.<br>
<p>Για να καταχωρηθούν οι προτιμήσεις σας πατήστε 'Υποβολή αλλαγών'</p><br>";
$langDeleteUser = "Επιβεβαίωση απεγγραφής χρήστη";
$langDeleteUser2 = "από την $langsCourse";
$langAskUser = "Αναζητήστε τον χρήστη που θέλετε να προστεθεί. Ο χρήστης θα πρέπει να έχει ενεργό λογαριασμό στην πλατφόρμα για να εγγραφεί στην $langsCourse.";
$langAskManyUsers = "<strong>Σημείωση</strong>:<br /> Οι χρήστες θα πρέπει να
                έχουν ήδη λογαριασμό στην πλατφόρμα για να γραφτούν στην $langsCourse.
                Εισάγετε τα ονόματα χρήστη (usernames) ή τους αριθμούς μητρώου σε ξεχωριστές γραμμές.";
$langNoUsersFound = "Δε βρέθηκε κανένας χρήστης με τα στοιχεία που δώσατε ή ο χρήστης υπάρχει ήδη στην $langsCourse.";
$langAdded = " προστέθηκε στην $langsCourse.";
$langAddError = "Σφάλμα! Ο χρήστης δεν προστέθηκε στην $langsCourse. Παρακαλούμε προσπαθήστε ξανά ή επικοινωνήστε με το διαχειριστή του συστήματος.";
$langCourseNotExist = "Ο κωδικός $langsOfCourse δεν υπάρχει.";
$langUsersAlreadyRegistered = "Οι παρακάτω χρήστες είναι ήδη γραμμένοι στην $langsCourse:";
$langUsersRegistered = "Οι παρακάτω χρήστες προστέθηκαν στην $langsCourse:";
$langNotifyRegUser1 = "Πραγματοποιήθηκε η εγγραφή σας στην $langsCourse ";
$langNotifyRegUser2 = " από τον διαχειριστή της $langsOfCourse.";

// search_user.php

$langAdminDefinition = "Διαχειριστής (δικαίωμα να αλλάζει το περιεχόμενο των $langsOfCourses)";
$langDeleteUserDefinition = "Διαγραφή (διαγραφή από τον κατάλογο χρηστών της <strong>παρόντος</strong> $langsOfCourse)";
$langNoTutor = "δεν είναι συντονιστής σε αυτή την $langsCourse";
$langYesTutor = "είναι συντονιστής σε αυτήν την $langsCourse";
$langGiveRightEditor = "Δικαίωμα $langsOfEditor";
$langGiveRightAdmin = "Δικαίωμα $langsOfTeacher";
$langGiveRightCourseReviewer = "Δικαίωμα $langsOfCourseReviewer";
$langRemoveRightEditor = "Αφαίρεση δικαιώματος $langsOfEditor";
$langRemoveRightAdmin = "Αφαίρεση δικαιώματος $langsOfTeacher";
$langRemoveRightCourseReviewer = "Αφαίρεση δικαιώματος $langsOfCourseReviewer";
$langUserAlreadyRegistered = "Ενας χρήστης με ίδιο όνομα / επίθετο είναι ήδη γραμμένος σε αυτή την $langsCourse.
                Δεν μπορείτε να τον (την) ξαναγράψετε.";
$langAddedToCourse = "είναι ήδη γραμμένος στην πλατφόρμα αλλά όχι σε αυτή την $langsCourse. Τώρα έγινε.";
$langChoiceLesson = "Επιλογή $langsOfCourses";
$langRegCourses = "Εγγραφή σε $langsCourse";
$langRegEnterCourse = "Εγγραφή και είσοδος στην $langsCourse";
$langChoiceDepartment = "Επιλογή $langOfFaculty";
$langCoursesRegistered = "Η εγγραφή σας στις $langsCourses που επιλέξατε έγινε με επιτυχία!";
$langNoCoursesRegistered = "<p>Δεν επιλέξατε $langsCourse για εγγραφή.</p><p> Μπορείτε να εγγραφείτε σε $langsCourse, την
επόμενη φορά που θα μπείτε στην πλατφόρμα.</p>";
$langLastUserVisits = "Τελευταίες επισκέψεις στην $langsCourse";
$langReqRegProf = "Αίτηση εγγραφής χρήστη (με δικαιώματα δημιουργίας $langsOfCourses)";
$langNewProf = "Εισαγωγή στοιχείων νέου λογαριασμού $langsOfTeacher";
$profsuccess = "Η δημιουργία νέου λογαριασμού $langsOfTeacher πραγματοποιήθηκε με επιτυχία!";
$ldaplastpage = "προηγούμενη σελίδα";
$mailsubject = "Αίτηση " . $langOfTeacher . " - Υπηρεσία Ασύγχρονης Τηλεκπαίδευσης";
$mailsubject2 = "Αίτηση " . $langOfStudent . " - Υπηρεσία Ασύγχρονης Τηλεκπαίδευσης";
$searchuser = "Αναζήτηση Συντονιστών / Χρηστών";
$langAsProf = "ως $langsTeacher";
$langCourseVisits = "Επισκέψεις ανά $langsCourse";
$langDurationVisitsPerCourse = "Διάρκεια συμμετοχής ανά $langsCourse";

// user registration
$langStudentCannotRegister = "Για να εγγραφείτε ως χρήστης με δικαιώματα $langsOfStudent, επικοινωνήστε με τους διαχειριστές της πλατφόρμας.";
$langTeacherCannotRegister = "Για να εγγραφείτε ως χρήστης με δικαιώματα $langsOfTeacher, επικοινωνήστε με τους διαχειριστές της πλατφόρμας.";
$langUserAccount = "Λογαριασμός $langOfStudent";
$langProfAccount = "Λογαριασμός $langOfTeacher";
$langNewUserAccountActivation = "Ενεργοποίηση Λογαριασμού $langOfStudent";
$langNewProfAccountActivation = "Ενεργοποίηση Λογαριασμού $langOfTeacher";



// list requests
$langTeacherRequestHasDeleted = "Η αίτηση του $langsOfTeacher διαγράφηκε!";
$langGoingRejectRequest = "Πρόκειται να απορρίψετε την αίτηση $langsOfTeacher με στοιχεία:";
$langTeacherRequestHasRejected = "Η αίτηση του $langsOfTeacher απορρίφθηκε";
$langRequestHasRejected = "Η αίτησή σας για εγγραφή στην πλατφόρμα $siteName απορρίφθηκε.";
$langCourseRegistrationDate = "Ημ/νία εγγραφής στην $langsCourse";
$langStudentParticipation = "$langCourses στις οποίες συμμετέχει ο χρήστης";
$langNoStudentParticipation = "Ο χρήστης δεν συμμετέχει σε καμία $langsCourse";
$langUserMergeForbidden = "Δεν είναι δυνατή η συγχώνευση $langsOfTeachers με μη-$langsTeachers. Παρακαλώ επιλέξτε κάποιον άλλο χρήστη.";
$langUnregFirst = "Θα πρέπει να διαγράψετε πρώτα τον χρήστη από τις παρακάτω $langsCourses:";
$langUnregTeacher = "Είναι " . $langsTeacher . " στις παρακάτω $langsCourses:";
$langOtherDepartments = "Εγγραφή σε $langsCourses άλλων τμημάτων/σχολών";
$langNoLessonsAvailable = "Δεν υπάρχουν Διαθέσιμες $langCourses.";


// formuser.php
$langUserRequest = "Αίτηση Δημιουργίας Λογαριασμού $langOfStudent";
$langUserOpenRequests = "Ανοικτές αιτήσεις $langOfStudents";
$langWarnReject = "Πρόκειται να απορρίψετε την αίτηση $langsOfStudent";
$langNewUserDetails = "Στοιχεία Λογαριασμού Χρήστη-$langOfStudent";
$langInfoProfReq = "Αν επιθυμείτε να έχετε πρόβαση στην πλατφόρμα με δικαιώματα δημιουργίας $langsOfCourses, παρακαλώ συμπληρώστε την παρακάτω αίτηση. Η αίτηση θα σταλεί στον υπεύθυνο διαχειριστή ο οποίος θα δημιουργήσει το λογαριασμό και θα σας στείλει τα στοιχεία μέσω ηλεκτρονικού ταχυδρομείου.";
$langUserSuccess = "Νέος λογαριασμός $langOfStudent";
$usersuccess = "Η δημιουργία νέου λογαριασμού " . $langsOfStudent . " πραγματοποιήθηκε με επιτυχία!";
$langAsUser = "(Λογαριασμός $langOfStudent)";
$langMailVerificationSubject = "Επιβεβαίωση Αίτησης Δημιουργίας Λογαριασμού $siteName";
$langMailChangeVerificationSubject = "Επιβεβαίωση e-mail λογαριασμού $siteName";
$langMailVerificationSuccess2 = "Για το σκοπό αυτό, ελέγξτε το ηλεκτρονικό σας ταχυδρομείο όπου θα σας έχει σταλεί email επιβεβαίωσης. Μόλις η επιβεβαίωση ολοκληρωθεί, θα σας σταλεί δεύτερο e-mail
                                από την ομάδα Διαχείρισης της Πλατφόρμας Ασύγχρονης Τηλεκπαίδευσης $siteName,
                        με τα στοιχεία σας.";
$langMailVerificationBody1 = "Ευχαριστούμε για την εγγραφή σας στο $siteName.<br><br>$langMailVerificationSuccess<br>$langMailVerificationClick<br>%s";
$langMailVerificationChangeBody = "Για να ενεργοποιηθεί ο λογαριασμός σας θα πρέπει να επιβεβαιωθεί η e-mail διεύθυνση σας.<br><br>$langMailVerificationClick<br>%s";
$langMailVerificationSuccess3 = "Ελέγξτε ότι είναι σωστή η παρακάτω ηλεκτρονική διεύθυνση και πατήστε στην «<strong>$langMailVerificationNewCode</strong>»";
$langMailVerificationReq = "Είναι απαραίτητο να επιβεβαιωθεί η e-mail διεύθυνση σας προτού προχωρήσετε.<br /><br />$langMailVerificationSuccess3";
$langMailVerificationSuccess4 = "Σύντομα θα λάβετε ένα e-mail από την Ομάδα Διαχείρισης της Πλατφόρμας Ασύγχρονης Τηλεκπαίδευσης $siteName, με τις απαραίτητες οδηγίες για την ολοκλήρωση της εγγραφής σας";
$langMailVerification = "Επιβεβαίωση E-mail $langUsersOf";

// mail_ver_settings.php
$langMailVerificationNotice = "Εάν είναι υποχρεωτική η επιβεβαίωση του e-mail του $langOfUserS
                και η επιβεβαίωση εκκρεμεί, τότε ισχύουν τα παρακάτω μέχρι να ολοκληρωθεί
                η επιβεβαίωση:<br /><ul><li>η πλατφόρμα θα παραπέμπει τον χρήστη στη σελίδα επιβεβαίωσης του e-mail</li>
                <li>ο χρήστης δεν θα λαμβάνει e-mail με ανακοινώσεις από τις $langsCourses που παρακολουθεί</li></ul>";




/* * **********************************************************
 * restore_course.php
 * *********************************************************** */
$langInvalidArchive = "Μη έγκυρο αρχείο $langsOfCourse";
$langRequest1 = "Κάντε κλικ στο Browse για να αναζητήσετε το αντίγραφο ασφαλείας της $langsOfCourse που θέλετε να επαναφέρετε. Μετά κάντε κλικ στο 'Αποστολή'.";
$langRequest2 = "Αν το αντίγραφο ασφαλείας, από το οποίο θα ανακτήσετε την $langsCourse, είναι μεγάλο σε μέγεθος και δεν μπορείτε να το ανεβάσετε, τότε μπορείτε να πληκτρολογήσετε τη ακριβή διαδρομή (path) που βρίσκεται το αρχείο στον server.";
$langRestoreStep1 = "1° Ανάκτηση $langsOfCourse από αρχείο ή υποκατάλογο.";
$langLesFound = "$langCourses που βρέθηκαν μέσα στο αρχείο:";
$langLesFiles = "Αρχεία της $langsOfCourse:";
$langInvalidCode = "Μη αποδεκτός κωδικός $langsOfCourse";
$langCopyFiles = "Τα αρχεία της $langsOfCourse αντιγράφηκαν.";
$langCourseExists = "Υπάρχει ήδη μία $langsCourse με αυτόν τον κωδικό !";
$langWarning = "<em><font color='red'>ΠΡΟΣΟΧΗ!</font></em> Αν επιλέξετε να μην προστεθούν οι χρήστες της $langsOfCourse και το αντίγραφο ασφαλείας της $langsOfCourse, περιέχει υποσυστήματα με πληροφορίες που σχετίζονται με τους χρήστες (π.χ. 'Εργασίες Χρηστών', 'Χώρος Ανταλλαγής Αρχείων' ή 'Ομάδες Χρηστών') τότε οι πληροφορίες αυτές <strong>ΔΕΝ</strong> θα ανακτηθούν.";
$langInfo1 = "Το αντίγραφο ασφαλείας που στείλατε περιείχε τις παρακάτω πληροφορίες για την $langsCourse.";
$langInfo2 = "Μπορείτε να αλλάξετε τον κωδικό της $langsOfCourse και ό,τι άλλο θέλετε (π.χ. περιγραφή, συντονιστής κ.λπ.)";
$langCourseType = "$langpre / $langpost";
$langUsersWillAdd = "Οι χρήστες της $langsOfCourse θα προστεθούν";
$langErrorLang = "Πρόβλημα! Δεν υπάρχουν γλώσσες για την $langsCourse!";

/* * ***************************************************************
 * search.php
 * *************************************************************** */

$langTitle_Descr = "αφορά τον τίτλο ή τμήμα από τον τίτλο της $langsOfCourse";
$langKeywords_Descr = "μία ή περισσότερες λέξεις κλειδιά που προσδιορίζουν τη θεματική περιοχή της $langsOfCourse";
$langInstructor_Descr = "το όνομα ή τα ονόματα των συντονιστών της $langsOfCourse";
$langCourseCode_Descr = "ο κωδικός της $langsOfCourse";
$langDescription_Descr = "αφορά την περιγραφή της $langsOfCourse, των θεματικών ενοτήτων και των σχετικών πόρων";
$langAllFacultes = "Σε όλες τις $langsFaculties";

/* * **********************************************************
 * upgrade.php
 * ********************************************************** */

$langUpgSucNotice = "Παρουσιάστηκε κάποιο σφάλμα, πιθανόν κάποια $langsCourse να μην δουλεύει εντελώς σωστά.<br>Σε αυτή την περίπτωση επικοινωνήστε μαζί μας στο <a href='mailto:eclass@gunet.gr'>eclass@gunet.gr</a> περιγράφοντας το πρόβλημα που παρουσιάστηκε και στέλνοντας (αν είναι δυνατόν) όλα τα μηνύματα που εμφανίστηκαν στην οθόνη σας.";
$langUpgCourse = "Αναβάθμιση $langsOfCourse";
$langUpgIndex = "Τροποποίηση αρχείου index.php της $langsOfCourse";
$langUpgIndexingNotice = "Λόγω του πλήθους των $langsOfCourses, οι μηχανές αναζήτησης και ευρετηριοποίησης έχουν απενεργοποιηθεί. Παρακαλούμε ανατρέξτε στις ρυθμίσεις της πλατφόρμας για την επαναφορά τους και ακολουθήστε τις οδηγίες για την ευρετηριοποίηση.";
$langUpgNotIndex = "Δεν πραγματοποιήθηκε η αλλαγή στον κατάλογο της $langsOfCourse";

/* * *****************************************************************
 * course_tools.php
 * ****************************************************************** */

$langAddCoursePage = 'Προσθήκη σελίδας συνεργασίας';
$langCoursePages = 'Σελίδες συνεργασίας';


$langNoAdminAccess = '
        <strong>Η σελίδα που προσπαθείτε να μπείτε απαιτεί όνομα χρήστη και συνθηματικό.</strong>
        <br>Η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να συνδεθείτε προτού προχωρήσετε σε άλλες ενέργειες. Πιθανόν, να έληξε η σύνοδός σας.';
$langLoginRequired = "
        <strong>Δεν είστε εγγεγραμμένος στην $langsCourse και επομένως δεν μπορείτε να χρησιμοποιήσετε το αντίστοιχο υποσύστημα.</strong>
        <br>Η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να εγγραφείτε στην $langsCourse, αν η εγγραφή είναι ελεύθερη.";
$langSessionIsLost = "
        <strong>Η σύνοδος σας έχει λήξει.</strong>
        <br>Η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να συνδεθείτε προτού προχωρήσετε σε άλλες ενέργειες.";
$langCheckProf = "
        <strong>Η ενέργεια που προσπαθήσατε να εκτελέσετε απαιτεί δικαιώματα διαχειριστή $langsOfCourse.</strong>
        <br>Η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να συνδεθείτε ξανά.";
$langCheckCourseAdmin = "
        <strong>Η ενέργεια που προσπαθήσατε να εκτελέσετε απαιτεί δικαιώματα διαχειριστή $langsOfCourse.</strong>
        <br>Η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να συνδεθείτε ξανά.";
$langLessonDoesNotExist = "
	<strong>Η $langsCourse που προσπαθήσατε να προσπελάσετε δεν υπάρχει.</strong>
	<br>Αυτό μπορεί να συμβαίνει γιατί εκτελέσατε μια μη επιτρεπτή ενέργεια ή λόγω τεχνικού προβλήματος
	στην πλατφόρμα.</p>";
$langCheckAdmin = "
        <strong>Η ενέργεια που προσπαθήσατε να εκτελέσετε απαιτεί δικαιώματα διαχειριστή.</strong>
        <br>Η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να συνδεθείτε ξανά.</p>";
$langCheckPowerUser = "
        <strong>Η ενέργεια που προσπαθήσατε να εκτελέσετε απαιτεί δικαιώματα διαχειριστή χρηστών και $langsOfCourses.</strong>
        <br>Η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να συνδεθείτε ξανά.";
$langCheckUserManageUser = "<strong>Η ενέργεια που προσπαθήσατε να εκτελέσετε απαιτεί δικαιώματα διαχειριστή χρηστών.</strong>
        <br>Η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να συνδεθείτε ξανά.";
$langCheckDepartmentManageUser = "<strong>Η ενέργεια που προσπαθήσατε να εκτελέσετε απαιτεί δικαιώματα διαχειριστή τμημάτων.</strong>
        <br>Η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να συνδεθείτε ξανά.";
$langCheckGuest = "
        <strong>Η ενέργεια που προσπαθήσατε να εκτελέσετε δεν είναι δυνατή με δικαιώματα επισκέπτη χρήστη.</strong>
        <br>Για λόγους ασφάλειας η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να συνδεθείτε ξανά.";
$langCheckMailVerify = "
        <strong>$langMailVerificationSuccess</strong>";
$langCheckPublicTools = "
        <strong>Προσπαθήσατε να αποκτήσετε πρόσβαση σε απενεργοποιημένο εργαλείο $langsOfCourse.</strong>
        <br>Για λόγους ασφάλειας η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να συνδεθείτε ξανά.";
$langWarnShibUser = "
        <strong>Προειδοποίηση:</strong> Επειδή η πιστοποίησή σας έγινε μέσω Shibboleth δεν έχετε αποσυνδεθεί από την πλατφόρμα!
        <br>Για να αποσυνδεθείτε θα πρέπει να κλείσετε τον browser σας.</p>";
$langCheckUserRegistration = "<strong>Η ενέργεια που προσπαθείτε να εκτελέσετε απαιτεί εγγραφή στην $langsCourse</strong>";


/* * *************************************************************
 * unreguser.php
 * ************************************************************** */

$langExplain = "Για να διαγραφείτε από την πλατφόρμα, πρέπει πρώτα να απεγγραφείτε από τις $langsCourses που είστε εγγεγραμμένος.";


//unregcours.php
$langCoursDelSuccess = "Η απεγγραφή σας από την $langsCourse έγινε με επιτυχία";
$langConfirmUnregCours = "Θέλετε σίγουρα να απεγγραφείτε από την $langsCourse";

/* * *****************************************************************
 * usage.php
 * ****************************************************************** */

$langAllCourses = "Όλες οι $langsCourses";

$langAndTotalCourseVisits = "και συνολικών επισκέψεων σε $langsCourses";

$langFavouriteCourse = "Προτίμηση $langOfCourses";
$langFavouriteCourses = "Δημοφιλέστερες $langCourses";

$langMonthlyCourseRegistrations = "Εγγραφές χρηστών στην $langsCourse";
$langMonthlyCourseRegistration = "Εγγραφή χρήστη στην $langsCourse";


$langStatAccueil = "Για το χρονικό διάστημα που ζητήθηκε, διατίθεται και η παρακάτω πληροφορία για το σύνολο των χρηστών της $langsOfCourse:";
$langUsageCoursesHeader = "Σύνολο $langsOfCourses";
$langStatOfFaculty = "Στατιστικά $langOfFaculty";

// for platform statistics
$langUsersCourse = "Χρήστες ανά $langsCourse";
$langVisitsCourseStats = "Επισκέψεις σε σελίδες $langsOfCourses";
$langTotalVisitsCourses = "Συνολικές επισκέψεις σε σελίδες $langsOfCourses";


/* * ***********************************************
 * log.class.php
 * *********************************************** */

$langCourseActions = "Ενέργειες $langsOfCourse";

/* * **************************************************************
 * video.php
 * *************************************************************** */

$langOpenDelosReplaceInfo = "<p>Αν κάποιος επιλεγμένος σύνδεσμος ήδη υπάρχει στα πολυμέσα, θα ανανεωθεί με τα τρέχοντα στοιχεία.</p><p><span style='color:red'>*</span> Ο σύνδεσμος έχει ήδη προστεθεί στα πολυμέσα της $langsOfCourse.</p><p><span style='color:red'>**</span> Ο σύνδεσμος έχει ήδη προστεθεί στα πολυμέσα, αλλά η πλατφόρμα OpenDelos διαθέτει νεότερη έκδοσή του.</p>";




/* * ***********************************************************
 * listerqusers.php
 * ************************************************************ */
$langRequestStudent = "Η αίτηση του $langsOfStudent έκλεισε!";


/* * ********************************************************************
  units.php
 * ********************************************************************* */

$langAddToCourseHome = "Εμφάνιση στην κεντρική σελίδα της $langsOfCourse";
$langSeenToCourseHome = "Εμφανίζεται στην κεντρική σελίδα της $langsOfCourse";
$langRemoveFromCourseHome = "Απόκρυψη από την κεντρική σελίδα της $langsOfCourse";
$langStudentViewEnable = "Προβολή σελίδας σαν $langsStudent";
$langStudentViewDisable = "Προβολή σελίδας σαν $langsTeacher";



/* * ********************************************************************
  mail_verify.php
 * ********************************************************************* */
$langMailNotVerified = "Το email σας δεν είναι επιβεβαιωμένο. Δεν θα μπορείτε να λαμβάνετε emails από τις $langsCourses έως ότου το επιβεβαιώσετε.
                Για να το επιβεβαιώσετε κάντε κλικ";



/* * ******************************************
  Personal calendar
 * ***************************************** */
$langEventcourse = "γεγονότα $langsOfCourses";
$langShowToAdminsandProfs = "διαχειριστές και $langsTeachers";




/* * ******************************************
  Messages for Big Blue Button
 * ***************************************** */

$langBBBConf = "Ρυθμίσεις \"Τηλεσυνεργασίας\" του $siteName";
$langBBBlockSettingsDisableCam = "Να μην επιτρέπεται διαμοιρασμός κάμερας από τα μέλη";
$langBBBwebcamsOnlyForModerator = "Εμφάνιση κάμερας χρηστών μόνο στους συντονιστές";
$langBBBlockSettingsDisableMic = "Να μην επιτρέπεται η χρήση μικροφώνου από τα μέλη";
$langBBBlockSettingsDisablePrivateChat = "Απενεργοποίηση ιδιωτικών συνομιλιών μεταξύ μελών";
$langBBBlockSettingsDisablePublicChat = "Απενεργοποίηση δημόσιων συνομιλιών από τα μέλη";
$langBBBlockSettingsDisableNote = "Απενεργοποίηση κοινόχρηστων σημειώσεων από τα μέλη";
$langBBBlockSettingsHideUserList = "Απόκρυψη λίστας χρηστών στα μέλη (μέσα στο BBB)";
$langNewBBBSessionPrivate = "Συμμετέχουν <strong>μόνο</strong>  εγγεγραμμένοι χρήστες <strong>της $langsOfCourse</strong>";
$langBBBNotServerAvailableStudent = "Η εξυπηρέτηση τηλεσυνεργασιών δεν είναι δυνατή. Επικοινωνήστε με τον $langsTeacher της $langsOfCourse.";
$langBBBNotServerAvailableTeacher = "Η τηλεσυνεργασία δεν είναι ενεργοποιημένη στην συνεργασία.";
$langBBBGetUsersError = "Δεν ήταν δυνατή η ανάκτηση πληροφοριών για την τηλεσυνεργασία ";
$langBBBSessionSuggestedUsers2 = "για περισσότερους από 80, προτείνεται το 50% των εγγεγραμμένων στην $langsCourse";
$langBBBMaxUsersJoinError = "Έχει συμπληρωθεί ο μέγιστος αριθμός συμμετεχόντων στην τηλεσυνεργασία. Παρακαλώ δοκιμάστε να συνδεθείτε αργότερα ή επικοινωνήστε με τον $langsOfTeacher της $langsOfCourse.";
$langBBBAddCourse = "Προσθήκη συνεργασίας";
$langBBBDeleteCourseSuccess = "Απενεργοποιήθηκε ο εξυπηρετητής τηλεσυνεργασίας για την συνεργασία";
$langBBBAddCourseFail = "Αδυναμία προσθήκης, παρακαλούμε επιλέξτε ένα έγκυρο κωδικό συνεργασίας";
$langBBBAddCourseFailExits = "Η συνεργασία υπάρχει ήδη";
$langToAllCourses = "Σε όλες τις $langsCourses";
$langToAllCoursesInfo = "Επιλέξτε αν ο εξυπηρέτης θα μπορεί να χρησιμοποιείται από όλα τις $langsCourses ή από ορισμένα";
$langToSomeCourses = "Σε συγκεκριμένες $langsCourses";
$langToSomeCoursesInfo = "Ο εξυπηρέτης θα μπορεί να χρησιμοποιείται από συγκεκριμένες $langsCourses. Για να ορίσετε ποιες $langsCourses θα τον χρησιμοποιούν μεταβείτε στην \"Αναζήτηση $langsOfCourses\" και επιλέξτε \"Ενέργειες\".";
$langToNoCourses = "Σε καμία από τις $langsCourses";
$langBBBCronEnable = 'Σημείωση: Μπορείτε να ενεργοποιήσετε αυτόματη καταγραφή παρουσιών στην τηλεσυνεργασία χωρίς επιπλέον ενέργειες των συντονιστών (άνοιγμα παραθύρου καταγραφής). {Διαβάστε περισσότερα}';


/* * ***********************************************************
 * blog.php
 * ************************************************************ */

$langCourseBlog = "Ιστολόγιο $langsOfCourse";
$langBlogPermStudents = "Ο $langsTeacher και τα $langsStudents έχουν δικαίωμα σύνταξης";
$langBlogPermTeacher = "Ο $langsTeacher μόνο έχει δικαίωμα σύνταξης";


/* * ***********************************************************
 * comments
 * ************************************************************ */
$langCourseCommenting = "Σχολιασμός στην αρχική σελίδα της $langsOfCourse";

/* * ***********************************************************
 * rating
 * ************************************************************ */
$langCourseRating = "Αξιολόγηση $langsOfCourse";
$langCourseAnonymousRating = "Αξιολόγηση $langsOfCourse από ανώνυμους χρήστες";
$langRatingAnonDisCourse = "Η αξιολόγηση από ανώνυμους χρήστες είναι απενεργοποιημένη για $langsCourses με μη ελεύθερη πρόσβαση χωρίς εγγραφή.";


/* * ***********************************************************
 * sharing
 * ************************************************************ */
$langCourseSharing = "Διαμοιρασμός σελίδας $langsOfCourse σε κοινωνικά δίκτυα";
$langSharingDisCourse = "Ο Διαμοιρασμός σε κοινωνικά δίκτυα είναι απενεργοποιημένος για $langsCourses με μη ελεύθερη πρόσβαση χωρίς εγγραφή.";



/* * ***********************************************************
 * Social Wall
 * ************************************************************ */
$langNoWallPosts = "Δεν υπάρχουν αναρτήσεις στον τοίχο της $langsOfCourse";




/**************************************************************
 * e-Portfolio
 * ************************************************************ */
$langePortfolioCollectionUserInfo = 'Στη συλλογή πόρων του e-Portfolio μπορείτε να προσθέσετε πόρους από τα υποσυστήματα: ιστολόγιο (προσωπικό) και προσωπικά έγγραφα, εφόσον αυτά είναι ενεργοποιημένα.
Οι αντίστοιχες καρτέλες εμφανίζονται μόνο αν έχουν προστεθεί πόροι από τα σχετικά υποσυστήματα στη συλλογή.';






/* * ***********************************************************
 * Other
 * ************************************************************ */

$langMyCoursesSide = "Οι $langsCourses μου";
$langNumOpenCoursesBanner = "ανοικτές<br>$langsCourses";
$langNumOpenCourseBanner = "ανοικτή<br>$langsCourse";
$langNationalOpenCourses = "Εθνική Πύλη Ανοικτών συνεργασιών";





/* * ***********************************************************
 * Auto Judge
 * ************************************************************ */
//auto_judge.php
$langAutoJudge = "Ρυθμίσεις αυτόματου κριτή του $siteName";
//antivirus.php
$langAntivirus = "Ρυθμίσεις λογισμικού προστασίας έναντι ιών του $siteName";
//waf.php
$langWaf = "Ρυθμίσεις τείχους προστασίας εφαρμογής ιστού του $siteName";








// Messages for external tools
$langOpenDelosDescription = "<p>Το OpenDelos είναι η πλατφόρμα ανοικτού λογισμικού που σχεδιάζει το GUNET για τη Διαχείριση, Καταγραφή και Μετάδοση Βιντεοδιαλέξεων.</p>
<p>Η πλατφόρμα υποστηρίζει τη δράση <a href='http://ocw-project.gunet.gr/'>Ανοικτών Ακαδημαϊκών $langOfCourses</a> σε συνδυασμό με την <a href='http://openeclass.org/'>πλατφόρμα συνεργασίας</a> και την εθνική πύλη αναζήτησης $langsOfCourses που επίσης αναπτύσσει το GUNET.</p>";
$langBBBDescription = "Το ανοικτό λογισμικό <a href=\"https://www.bigbluebutton.org/\" target=\"_blank\">BigBlueButton</a> αποτελεί  ένα πλήρες σύστημα άμεσης web-based επικοινωνίας και συνεργασίας $langsOfTeachers και $langsOfStudents.</p>
<p>Δεν απαιτείται εγκατάσταση πρόσθετου υλικού (Software ή Hardware) και εκτελείται απευθείας από τον πλοηγό διαδικτύου (Internet Explorer, Firefox, Chrome, Safari, κ.α)r. Για τη σύνδεση της πλατφόρμας με μία εγκατεστημένη πλατφόρμα BigBlueButton επιλέξτε <a href=\"bbbmoduleconf.php\">Ρυθμίσεις</a>.</p>";
$langBBBLongDescription = "Σύνδεση με την υπηρεσία τηλεδιάσκεψης BigBlueButton.";
$langAutojudgeDescription = "<p>Ο αυτόματος κριτής είναι ένα εργαλείο που επιτρέπει την αυτόματη διόρθωση προγραμματιστικών εργασιών. Πιο συγκεκριμένα, μέσω του εργαλείου ο συντονιστής μπορεί να ορίσει σενάρια που περιλαμβάνουν input και output βάσει των οποίων οι αναρτώμενες εργασίες βαθμολογούνται αυτόματα.</p><p>Το συγκεκριμένο υποσύστημα συνδέεται με τρίτες υπηρεσίες μεταγλώττισης οι οποίες μπορούν να επιλεχθούν στις <a href=\"autojudgemoduleconf.php\">Ρυθμίσεις</a>.</p>";

$langOpenMeetingsDescription = "<p>Το υποσύστημα <strong>Τηλεσυνεργασίας</strong> της πλατφόρμας συνεργασίας υποστηρίζεται λειτουργικά από το ανοικτό λογισμικό <a href=\"http://openmeetings.apache.org/\" target=\"_blank\">Apache OpenMeetings</a> το οποίο αποτελεί  ένα πλήρες σύστημα άμεσης web-based επικοινωνίας και συνεργασίας $langsOfTeachers και $langsOfStudents.</p>
<p>Το OpenMeetings ανήκει στις εφαρμογές τηλεδιάσκεψης / σύγχρονης τηλεκπαίδευσης που δεν απαιτούν την εγκατάσταση πρόσθετου υλικού (Software ή Hardware). Η εφαρμογή εκτελείται απευθείας από τον πλοηγό διαδικτύου (Internet Explorer, Firefox, Chrome, Safari, κ.α) με χρήση του Adobe Flash Player. Για τη σύνδεση της πλατφόρμας με μία εγκατεστημένη πλατφόρμα OpenMeetings επιλέξτε <a href=\"openmeetingsconf.php\">Ρυθμίσεις</a>.</p>";

$langLtiPublishShortDescription = "Δημοσίευση $langsOfCourses μεσω πρωτοκόλλου LTI.";
$langLtiPublishLongDescription = "Δημοσίευση $langsOfCourses μεσω πρωτοκόλλου LTI.";


// Messages for OpenMeetings
$langOpenMeetingsConf = "Ρυθμίσεις \"OpenMeetings\" του $siteName";











/* * ******************************************
  Messages for collaboration platform
 * ***************************************** */

$langCollaboration = "Συνεργασία";
$langSmCollaboration = "συνεργασία";
$langOfCollaboration = "Συνεργασίας";
$langOfSmCollaboration = "συνεργασίας";
$langCollaborationPlatform = "Πλατφόρμα συνεργασίας";
$langEnableCollaboration = "Ενεργοποίηση πλατφόρμας συνεργασίας";
$langAlwaysEnabledCollaboration = "Μόνιμα ενεργοποιημένη";
$langCollaborationCreate = "Δημιουργία συνεργασίας";
$langLogoutFromCollaboration = "πλατφόρμα συνεργασίας";
$langCollaborationPlatformInfo = "Η πλατφόρμα συνεργασίας περιγράφει αναλυτικά την λειτουργικότητα και τεχνική/τεχνολογική
προσέγγιση για την ψηφιακή πλατφόρμα επικοινωνίας και του περιβάλλοντος συνεργασίας των
μελών των διαφόρων κοινοτήτων (στελέχη των συνεργαζόμενων φορέων).</br> Τα εργαλεία που ενσωματώνει εξασφαλίζουν τις απαιτούμενες ηλεκτρονικές
υποδομές για την υποστήριξη συνεργασίας μέσω Διαδικτύου (π.χ. forums, ανταλλαγή
μηνυμάτων, ανταλλαγή αρχείων, ψηφοφορίες, κλπ.) στο πλαίσιο του έργου.";
$langOpenCoursesTeacherConfirm = "Δήλωση Συντονιστή - Το Διαθέσιμο Συνεργασιακό Υλικό καλύπτει το 100% της Διδακτέας Ύλης";
$langOpenCoursesTeacherConfirmVideo = "Δήλωση Συντονιστή - Οι Βιντεοσκοπημένες Διαλέξεις καλύπτουν το 80% της Διδακτέας Ύλης";
$langCMeta['instructorGroup'] = "Συντονιστες";
$langTutorDefinition = "Συντνονιστής (δικαίωμα να επιβλέπει τις ομάδες χρηστών)";
$langTheTeacher = 'Ο συντονιστής';
$langCMeta['instructorGroup'] = "Συντονιστές";
$langTiiSViewReports = "Πρόσβαση χρηστών στην Αναφορά Ομοιότητας";
$langJustEdited = "Μόλις ενημερώσατε την συνεργασία με τίτλο ";
$langCreateCourseLeftForm = "Η δημιουργία συνεργασίας είναι η πιο σημαντική ενέργεια του χρήστη – συντονιστή στην πλατφόρμα.</br></br>
                             Πληκτρολογήστε έναν τίτλο για την συνεργασία σας.</br></br>
                             Πληκτρολογήστε μια σύντομη περιγραφή για το συνεργασία.</br></br>
                             Επιλέξτε το Τμήμα στα πλαίσια του οποίου προσφέρεται η συνεργασία ή την κατηγορία συνεργασιών στην οποία ανήκει.</br></br>
                             Επιλέξτε μία από τις διαθέσιμες μορφές συνεργασιών. </br></br>
                             Καθορίστε, προαιρετικά, την άδεια διάθεσης της συνεργασίας σας.</br></br>
                             Καθορίστε τον τύπο πρόσβασης στην συνεργασία σας. </br></br>
                             Για να ολοκληρωθεί η διαδικασία δημιουργίας της συνεργασίας, πατήστε το κουμπί με την ένδειξη «Δημιουργία Συνεργασίας».";
$langMonthlyReportInfo = "Παρουσιάζονται συγκεντρωτικά στοιχεία (συνεργασίες, χρήστες) των τελευταίων 24 μηνών.";
$langAddingDirectoryIndex = 'Προσθήκη αρχείων index.html στους υποκαταλόγους συνεργασιών';
$langAdministratorGroup = 'Διαχείριση Ομάδων Χρηστών';
$m['WorkToAllUsers'] = "Σε όλα τα $langsOfStudentss";
$m['WorkToUser'] = "Συγκεκριμένα $langsOfStudentss";
$langOpenCoursesShort = "Ανοικτές συνεργασίες";
$langTypeCollaboration = "Συνεργασία";



/* * ***********************************************************
 * Abuse Report
 * ************************************************************ */

$langAbuseReportSaveSuccess = "Η αποστολή της αναφοράς προς τους διαχειριστές του $langsOfCourse έγινε επιτυχώς. Η ενημέρωσή τους πραγματοποιήθηκε με την αποστολή μηνύματος από το υποσύστημα Ανταλλαγής Μηνυμάτων.";
$langNoAbuseReports = "Δεν υπάρχουν αναφορές κατάχρησης για αυτή την $langsCourse";



$langNewEclassVersion = 'Νέα έκδοση πλατφόρμας συνεργασίας';
$langNewEclassVersionInfo = 'Μια νέα έκδοση της πλατφόρμας συνεργασίας, %s,
είναι διαθέσιμη. Παρακαλούμε επισκεφθείτε την ιστοσελίδα %s για πληροφορίες
αναβάθμισης.';
/* * *********************************************************
 * install.php
 * ********************************************************* */
$langTitleInstall = "Οδηγός εγκατάστασης πλατφόρμας συνεργασίας";
$langWelcomeWizard = "Καλωσορίσατε στον οδηγό εγκατάστασης της πλατφόρμας συνεργασίας!";
$langInstallBullet3 = "Δικαιώματα εγγραφής στον κατάλογο όπου η πλατφόρμα συνεργασίας έχει αποσυμπιεστεί.";
$langCheckReq = "Έλεγχος προαπαιτούμενων προγραμμάτων για τη λειτουργία της πλατφόρμας";
$langInfoLicence = "Η πλατφόρμα συνεργασίας είναι ελεύθερη εφαρμογή και διανέμεται σύμφωνα με την άδεια GNU General Public Licence (GPL). <br />
                Παρακαλούμε διαβάστε την άδεια και κάνετε κλικ στο 'Αποδοχή'";
$langMainDB = "Κύρια Βάση Δεδομένων της πλατφόρμας";
$langLocalPath = "Path της πλατφόρμας στον εξυπηρετητή";
$langWarnHelpDesk = "Προσοχή: στο \"Email Helpdesk\" στέλνονται οι αιτήσεις συντονιστών για λογαριασμό στην πλατφόρμα";
$langErrorConfig = "<strong>Παρουσιάστηκε σφάλμα!</strong><br><br>Δεν είναι δυνατή η δημιουργία του αρχείου config.php.<br><br>Παρακαλούμε ελέγξτε τα δικαιώματα πρόσβασης στους υποκαταλόγους της πλατφόρμας και δοκιμάστε ξανά την εγκατάσταση.";
$langProtect = "Συμβουλή: Για να προστατέψετε την πλατφόρμα, αλλάξτε τα δικαιώματα πρόσβασης των αρχείων
           <tt>/config/config.php</tt> και <tt>/install/index.php</tt> και
           επιτρέψτε μόνο ανάγνωση (CHMOD 444).";
$langInstallSuccess = "Η εγκατάσταση ολοκληρώθηκε με επιτυχία! Κάντε κλικ παρακάτω για να μπείτε στην πλατφόρμα συνεργασίας";
$langEnterFirstTime = "Είσοδος στην πλατφόρμα";
$lang_max_glossary_terms = "Δεν επιτρέπεται η εμφάνιση ορισμών όρων στις σελίδες $langsOfCourses, εφόσον ο συνολικός αριθμός όρων στο γλωσσάριο είναι μεγαλύτερος από:";
$lang_email_required = "Να είναι υποχρεωτικό το email του $langOfUserS";
$lang_email_verification_required = "Να είναι υποχρεωτική η επιβεβαίωση του e-mail του $langOfUserS";
$lang_dont_mail_unverified_mails = "Να μην γίνεται αποστολή e-mail σε $langUsersS που δεν έχουν επιβεβαιώσει την ηλεκτρονική τους διεύθυνση";
$lang_am_required = "Να είναι υποχρεωτικός ο αριθμός μητρώου του $langsOfStudent κατά την εγγραφή";
$lang_dropbox_allow_student_to_student = "Να επιτρέπεται η ανταλλαγή μηνυμάτων $langsOfCourse μεταξύ $langsOfStudents στο υποσύστημα 'Ανταλλαγή Μηνυμάτων'";
$lang_course_multidep = "Να επιτρέπεται στις $langsCourses να ανήκουν σε πολλές $langsFaculties";
$lang_user_multidep = "Να επιτρέπεται η εγγραφή χρηστών σε πολλές $langsFaculties";
$lang_restrict_teacher_owndep = "Να μην επιτρέπεται η δημιουργία $langsOfCourses από τους $langsTeachers στα τμήματα που δεν ανήκουν";
$lang_allow_teacher_clone_course = "Να επιτρέπεται η κλωνοποίηση $langsOfCourses από τους $langsTeachers";
$lang_disable_log_course_actions = "Απενεργοποίηση καταγραφής ενεργειών χρηστών μέσα στα $langsCourses";
$lang_disable_log_system_actions = "Απενεργοποίηση καταγραφής ενεργειών χρηστών εκτός $langsOfCourses";
$langDefaultInstitutionName = 'Ακαδημαϊκό Διαδίκτυο GUNet';
$lang_course_metadata = "Μετασχολιασμός $langOfCourses";
/* * **********************************************************
 * upgrade.php
 * ********************************************************** */
$langUpgTooOld = 'Η έκδοση της πλατφόρμας από την οποία γίνεται αναβάθμιση
   είναι πολύ παλιά. Παρακαλούμε αναβαθμίστε την εγκατάστασή σας πρώτα
   στην έκδοση 3.0 και στη συνέχεια στην τελευταία έκδοση.';
$langUpgReady = "Είστε πλέον έτοιμοι να χρησιμοποιήσετε την καινούρια έκδοση της πλατφόρμας!";
$langUpgradeStart = 'Έναρξη αναβάθμισης της πλατφόρμας';
$langDatabaseExists = 'Προσοχή: Η βάση δεδομένων "%s" υπάρχει ήδη. Οι πίνακες
    που περιέχονται σε αυτή θα διαγραφούν αν έχουν ονόματα ίδια με αυτά που
    χρησιμοποιεί η πλατφόρμα (είτε συμπτωματικά, είτε αν πρόκειται για υπάρχουσα
    εγκατάσταση της πλατφόρμας). Πριν προχωρήσετε, επιβεβαιώστε ότι δεν υπάρχει
    πρόβλημα ή επιστρέψτε στο προηγούμενο βήμα και εισαγάγετε άλλο όνομα βάσης.';
$langDefaultThemeSettings = 'Collaboration Default';
$langLoginBanner = "Login Screen Platform Banner";
$langNextGeneration = "Το έργο υλοποιείται στο πλαίσιο του Εθνικού Σχεδίου Ανάκαμψης και Ανθεκτικότητας Ελλάδα 2.0 µε τη χρηματοδότηση της Ευρωπαϊκής Ένωσης – NextGenerationEU";
$langInfoUserDuration = "Στους παρακάτω χρόνους συμμετοχής <b>δεν</b> συμπεριλαμβάνονται οι χρόνοι στην Τηλεσυνεργασία</em>.";
$langCookieInfo = "Αυτός ο ιστότοπος χρησιμοποιεί cookies για να διασφαλίσει ότι θα έχετε την καλύτερη εμπειρία στον ιστότοπό μας.";
$langCategoryDescription = "Περιγραφή $langsOfCourse";
$langImplBodies = "Φορείς Υλοποίησης";




/* * **********************************************************
 * manual.php
 * ********************************************************** */
$langDesPlatform = "Σύντομη Περιγραφή Πλατφόρμα Συνεργασίας για Θέματα Κλιματικής Αλλαγής και Μνημείων Πολιτιστικής Κληρονομιάς";
$langManualTeacher = "Χρήστης με δικαιώματα δημιουργίας συνεργασίας";
$langManualStudent = "Απλός χρήστης";
$langCollaborationHome = "Ηλεκτρονική συνεργασία";
$langPasswordReset = "Ανάκτηση συνθηματικού";
$langMenuChoicesOfUser = "Μενού επιλογών χρήστη";
$langManageCollaborations = "Διαχείριση συνεργασιών";
$langManagePlatform = "Διαχείριση πλατφόρμας";

/* * **********************************************************
 * collaboration invitation
 * ********************************************************** */

$langCourseInvitationHelp = 'Αν η επιλογή είναι ενεργή, οι διαχειριστές συνεργασιών μπορούν να προσκαλούν εξωτερικούς χρήστες στην πλατφόρμα για εγγραφή στην συνεργασία τους.';
$langCourseUsersInvitation = "Πρόσκληση χρηστών σε συνεργασία";
$langcourseExternalUsersInviation = "Πρόσκληση εξωτερικών χρηστών";
$langCourseInviteOne = "Πρόσκληση χρήστη";
$langCourseInviteMany = "Πρόσκληση χρηστών";
$langDeleteInvitation = "Διαγραφή πρόσκλησης";
$langDeleteInvitationSuccess = "Η πρόσκληση διαγράφτηκε";
$langCourseInvitationSubject = "Πρόσκληση εγγραφής στην πλατφόρμα";
$langCourseInvitationBody1 = "Έχετε λάβει πρόσκληση εγγραφής στην πλατφόρμα $siteName προκειμένου να συμμετάσχετε στη συνεργασία";
$langCourseInvitationBody2 = "Για να προχωρήσετε στην εγγραφή, παρακαλούμε ακολουθήστε τον παρακάτω σύνδεσμο.";
$langCourseInvitationSent = "Η πρόσκληση στάλθηκε!";
$langCourseInvitationsSent = "Οι προσκλήσεις στάλθηκαν σε";
$langUserWithEmail = "Ο χρήστης με e-mail";
$langAlreadyAccount = "είχε ήδη λογαριασμό στην πλατφόρμα και προστέθηκε στη συνεργασία σας.";
$langAlreadyRegistered = "ήταν ήδη εγγεγραμμένος στη συνεργασία σας.";
$langAlreadyRegisteredUsers = "Οι παρακάτω χρήστες είχαν ήδη λογαριασμό στην πλατφόρμα και προστέθηκαν στη συνεργασία";
$langInvitationCustomEmail = "
            <p>Placeholder μεταβλητών </p>
                <br>
                <ul>
                 <li>[email] : Διεύθυνση e-mail</li>
                 <li>[link] : Σύνδεσμος εγγραφής</li>
                </ul>";
$langErrorInserting = "Οι παρακάτω εγγραφές του αρχείου που αποστείλατε είχαν κάποιο πρόβλημα. Είτε το e-mail δεν είναι έγκυρο, είτε τα πεδία ήταν περισσότερα από τα αναμενόμενα:";
$langCourseInvitationUsersExcelInfo = "Μπορείτε να αποστείλετε ένα αρχείο λογιστικού φύλλου (π.χ. xls, xlsx, csv) με μία ή τρείς στήλες.
Η πρώτη στήλη πρέπει να περιέχει τα e-mail των χρηστών που επιθυμείτε να προσκαλέσετε στη συνεργασία.
Η δεύτερη και τρίτη στήλη μπορούν προαιρετικά να περιέχουν το επίθετο και όνομα κάθε χρήστη.
Σημειώστε ότι χρήστες που υπάρχουν ήδη στην πλατφόρμα με το e-mail θα προστεθούν αμέσως στη συνεργασία χωρίς να λάβουν πρόσκληση και χωρίς άλλη ειδοποίηση.";
$langSendReminder = "Αποστολή υπενθύμισης";
$langNoLongerValid = 'Ο σύνδεσμος που ακολουθήσατε δεν είναι πλέον έγκυρος.';
$langInvitationAlreadyUsed = 'Έχετε ήδη εγγραφεί στην πλατφόρμα μέσω του
    συνδέσμου που ακολουθήσατε. Μπορείτε τώρα να συνδεθείτε με όνομα χρήστη τη
    διεύθυνση e-mail σας και τον κωδικό πρόσβασης που είχατε επιλέξει.';
$langRegisterAsVisitor = 'Εγγραφή ως επισκέπτης';
$langCourseInvitation = 'Πρόσκληση εγγραφής στη συνεργασία';
$langPreviewCollaboration = " συνεργασίας";
$langUnregCollaboration = "Απεγγραφή από την συνεργασία";
$langDisableCollaborationModulesHelp = "Μπορείτε να επιλέξετε ποια από τα παρακάτω υποσυστήματα επιθυμείτε να απενεργοποιηθούν από όλες τις συνεργασίες της πλατφόρμας.";
$langDefaultModulesCollaborationHelp = "Τα παρακάτω υποσυστήματα είναι ενεργοποιημένα εξ ορισμού στις νέες συνεργασίες της πλατφόρμας κατά τη δημιουργία τους.";
$langCourseMetadata = "Μεταδεδομένα $langsOfCourse";

$langInfoAboutCollabRegistration = "Η συνεργασία που επιλέξατε είναι κλειστή. Για να εγγραφείτε, θα πρέπει
να συμπληρώσετε την παρακάτω αίτηση, η οποία θα καταγραφεί και θα αποσταλεί στους διαχειριστές της συνεργασίας.";
$langLabelCollabUserRequest = "Αίτηση εγγραφής στη συνεργασία";
$langRequestReasonsCollab = "Αναφέρετε τους λόγους που επιθυμείτε την εγγραφή σας στη συνεργασία.";
$m['password_collab'] = "Συνθηματικό συνεργασίας";
$lang_openCourse_inModal = "Να εμφανίζονται οι πληροφορίες της συνεργασίας σε Modal(Πλαίσιο) στις ανοικτές συνεργασίες;</br>
                            Σε περίπτωση που δεν επιλέξετε αυτήν την επιλογή, οι πληροφορίες της συνεργασίας θα εμφανίζονται σε καινούρια σελίδα του browser σας.";
$langGroupWorkIntro = "
	Παρακάτω εμφανίζονται οι διαθέσιμες εργασίες που έχουν ανατεθεί
	στα πλαίσια αυτού της $langsOfCourse. Παρακαλούμε επιλέξτε την εργασία όπου θέλετε
	να αποστείλετε το αρχείο ως εργασία της ομάδας σας, και συμπληρώστε
	τυχόν σχόλια που θέλετε να διαβάσει ο διδάσκων της $langsOfCourse. Σημειώστε ότι
        αν έχει υποβληθεί ήδη μια εργασία από εσάς ή άλλο μέλος της ομάδας σας
        και αποστείλετε ένα νέο αρχείο για την ίδια εργασία, τότε το παλιό
	αρχείο αυτό θα διαγραφεί και θα αντικατασταθεί από το νέο. Τέλος,
	δεν μπορείτε να στείλετε αρχείο σε εργασία που έχει ήδη βαθμολογηθεί
	από τον συντονιστή-συμβουλο.";
$langSessionCompletionActivated = "Η ολοκλήρωση της συνεδρίας ενεργοποιήθηκε";
$langInvalidCourseSessionPrerequisites = "Η ολοκλήρωση της συνεδρίας δεν είναι ενεργοποιημένη.";
$langManageSession = "Διαχείριση συνεδριών";
$langSessionCompletion = "Ολοκλήρωση συνεδρίας";
$langSessionCompletionMessage = "Η συνεδρία ολοκληρώθηκε με επιτυχία";
$langNewSessionPrerequisiteFailInvalid = "Αδυναμία προσθήκης! Παρακαλούμε επιλέξτε μία έγκυρη συνεδρία.";
$langSessionHasNotCompletionEnabled = "Αδυναμία προσθήκης! Η συνεδρία που επιλέξατε δεν έχει ενεργοποιημένη την ολοκλήρωση συνεδρίας.";
$langNewSessionPrerequisiteFailAlreadyIn = "Αδυναμία προσθήκης, η συνεδρία που επιλέξατε υπάρχει ήδη στη λίστα με τα προαπαιτούμενα.";
$langSessionPrerequisites = "Προαπαιτούμενη συνεδρία";
$langNoSessionPrerequisite = "Δεν έχει οριστεί προαπαιτούμενη συνεδρία.";
$langSessionNotStarted = "Η συνεδρία δεν έχει ξεκινήσει ακόμα";
$langSessionNotCompleted = "Οι δραστηριότητες της προηγούμενης συνεδρίας δεν έχουν ολοκληρωθεί";
$langResourceBelongsToSessionPrereq = "Η δραστηριότητα συμμετέχει στην ολοκλήρωση της συνεδρίας";
$langSessionResourseParticipatesInSessionCompletion = "Ο πόρος δεν μπορεί να διαγραφεί καθώς συμμετέχει ως δραστηριότητα ολοκλήρωσης της συνεδρίας";
$langInsertQuestionnaire = "ερωτηματολογίου";
$langWithoutCompletedResource = "Χωρίς την χρήση κριτηρίων";
$langSessionHasCompleted = "Η συνεδρία ολοκληρώθηκε επιτυχώς";
$langCompletedSessionWithoutActivity = "Ολοκλήρωση συνεδρίας χωρίς την χρήση πόρων";
$langSessionCompletedNotContinue = "Η ολοκλήρωση της συνεδρίας δεν είναι επιτρεπτή.</br>
                                    Ισως υπάρχει μη ολοκληρωμένη προαπαιτούμενη συνεδρία ή υπάρχουν δραστηριότητες που δεν έχουν ολοκληρωθεί";
$langCompletedSession = "Ολοκληρωμένη";
$langCompletedConsulting = "Ολοκλήρωση συμβουλευτικής";
$langAddSessionConsultingCompleted = "Η καταχώριση των συνεδριών για την ολοκλήρωση συμβουλευτικής ολοκληρώθηκε.";
$langCompletedConsultingInfo = "Παρακάτω εμφανίζονται οι συνεδρίες για τις οποίες η <strong>ολοκλήρωση συνεδρίας</strong> έχει ενεργοποιηθεί. </br>
                                Επιλέξτε ποιες από αυτές θα αντιστοιχούν στην ολοκλήρωση της συμβουλευτικής ενός χρήστη.</br>
                                Για την συνεδρία που θα επιλεχθεί, θα εμφανίζεται αναλυτικά το ποσοστό ολοκλήρωσης κάθε χρήστη.";
$langPercentageCompletedConsultingByUser = "Ποσοστό ολοκλήρωσης συνεδριών ανά χρήστη";
$langPercentageCompletedConsulting = "Ποσοστό ολοκλήρωσης συνεδριών";
$langCompletedSessions = "Ολοκληρωμένη συνεδρία <i class='fa-solid fa-check fa-lg Success-200-cl ps-2'></i>";
$langNotCompletedSession = "Μη ολοκληρωμένη συνεδρία";
$langResponsibleOfSession = "Εγγεγραμμένοι σύμβουλοι - Υπευθύνος συνεδρίας";
$langSessionParticipants = "Εγγεγραμμένοι ωφελούμενοι/μέλοι - Συμμετέχοντες";
$langContinueToCompletetionWithoutAct = "Θέλετε να προχωρήσετε στην ολοκλήρωση της συνεδρίας χωρίς την υποβολή κάποιων δραστηριοτήτων - πόρων;";
$langOfSubmitAssignment = "Με υποβολή εργασίας στο εργαλείο <Εργασίες>";
$langOfSubmitDocument = "Με προβολή εγγράφου";
$langSessionCompletedIsActivated = "Η ολοκλήρωση συνεδρίας χωρίς την υποβολή δραστηριοτήτων είναι ήδη ενεργοποιημένη";
$langDocSender = "Παραδοτέα χρηστών";
$langPreviousDocDeleted = "Διαγράφηκε το προηγούμενο έγγραφο.";
$langWithTCComplited = "Με την ολοκλήρωση τηλεδιάσκεψης";
$langTCComplited = "Ολοκλήρωση τηλεδιάσκεψης";
$langContinueToCompletetionWithCompletedTC = "Θέλετε να προχωρήσετε στην ολοκλήρωση της συνεδρίας μόλις ολοκληρωθεί η απομακρυσμένη τηλεδιάσκεψη;";
$langResourceAddedWithSuccess = "Ο πόρος προστέθηκε επιτυχώς.";
$langResourceExists = "Ο πόρος υπάρχει ήδη.";
$langResourceNoExists = "Ο πόρος δεν υπάρχει.";
$langDelAllSessions = "Διαγραφή όλων των συνεδριών";
$langContinueToDelAllSessions = "Θέλετε να προχωρήσετε στην διαγραφή όλων των συνεδριών;";
$langDelAllSessionSuccess = "Οι συνεδρίες διαγράφηκαν επιτυχώς.";
$langALLSessions = "Όλες";
$langSubmitCompletion = "Υποβολή ολοκλήρωσης";
$langContinueToUserAwarded = "Η ενέργεια αυτή σχετίζεται με την ολοκλήρωση παραδοτέου του χρήστη και αφορά την δραστηριότητα που αναγράφεται στην στήλη «Αφορά» του πίνακα.</br>
                              Θέλετε να προχωρήσετε στην συγκεκριμένη ενέργεια;";
$langDocCompletionSuccess = "Η ενέργεια ολοκληρώθηκε επιτυχώς.";
$langNoSubmitCompletion = "Ακύρωση ολοκλήρωσης";
$langContinueToNoSubmiCompletion = "Θέλετε να προχωρήσετε στην ακύρωση ολοκλήρωσης";
$langDocCompletionNoSuccess = "Ακυρώσατε την ολοκλήρωση του εγγράφου.";
$langExistsTc = "Η συγκεκριμένη τηλεδιάσκεψη υπάρχει ήδη.";
$langViewDeliverable = "Προβολή παραδοτέων";
$langExistResourcesForCompletion = "Υπάρχουν πόροι προς ολοκλήρωση. Η απενεργοποίηση δεν ολοκληρώθηκε.";
$langExistsInCompletedPrerequisite = "Υπάρχει προαπαιτούμενη συνεδρία που δεν έχει ολοκληρωθεί.";
$langInfoForUploadedDeliverable = "Μπορείτε να διαγράψετε το παραδοτέο σας εφόσον δεν έχει ελεγχθεί από τον σύμβουλο.";
$langUsedCertRes = "Η δραστηριότητα έχει ήδη χρησιμοποιηθεί από κάποιον ωφελούμενο.";
$langFileExistsWithSameName = "Υπάρχει αρχείο με το ίδιο όνομα. Το ανέβασμα δεν ολοκληρώθηκε.";
$langAddCompletionCriteria = "Προσθήκη κριτηρίων";
$langUserDeliverable = "Παραδοτέα χρήστη";
$langTotalDeliverable = "Σύνολο παραδοτέων";
$langInfoUploadExistedDeliverable = "Αν στείλετε κάποιο αρχείο και υπάρχει ήδη ένα παραδοτέο σας, τοτε το παλιό θα διαγραφεί και θα αντικατασταθεί με τον καινούριο.";
$langResourceDateCreated = "Δημιουργήθηκε";
$langUploadOnBehalfOf = "Ανέβασμα αρχείου εκ μέρους κάποιου ωφελούμενου";
$langOnBehalfOfUser = "Εκ μέρους του χρήστη";
$langResourceΝοBelongsToSessionPrereq = "Η δραστηριότητα <strong> ΔΕΝ </strong> συμμετέχει στην ολοκλήρωση της συνεδρίας";
$langNotExistDeliverables = "Δεν υπάρχουν παραδοτέα";
$langTypeOutComment = "Πληκτρολογήστε το σχόλιο σας...";
$langAddCommentsSuccess = "Το σχόλιο σας προστέθηκε με επιτυχία.";
$langCommentsByConsultant = "Σχόλια συμβούλου";
$langInsertPassage = "Προσθήκη κειμένου";
$langSomeComments = "Ενημέρωση σχετικά με το παραδοτέο σας";
$langSendEmailWithComments = "Με την υποβολή των σχόλιων σας, θα σταλεί ειδοποίηση στον χρήστη.";
$langNoExistsTClink = "Δεν βρέθηκε ο σύνδεσμος τηλεδιάσκεψης στους πόρους της συνεδρίας.";
$langNotFolders = "Για την ολοκλήρωση της συνεδρίας μέσω της υποβολής παραδοτέου, δεν μπορούν να επιλεγούν συμπιεσμένοι φάκελοι παρά μόνο αρχεία.</br>
                    Θα αγνοηθεί αν επιλεγεί κάποιος φάκελος ως παραδοτέο.";
$langSessionAcceptance = "Έχετε επιλεγεί να συμμετάσχετε στην τρέχουσα συνεδρία.
                          Για να ολοκληρωθεί η διαδικασία θα πρέπει να πατήσετε στο παρακάτω σύνδεσμο.
                          Ο σύνδεσμος θα σας ανακατευθύνει στην σελίδα της συνεδρίας αφού πρώτα συνδεθείτε στην πλατφόρμα.
                          Για να προχωρήσετε στην εγγραφή πατήστε υποβολή.";
$langQuestionAcceptanceSession = "Αποδέχεστε την εγγραφή σας στην συγκεκριμένη συνεδρία;</br>
                                 Ο Σύμβουλος θα ενημερωθεί με ηλεκτρονικό μήνυμα σχετικά με την επιλογής.";
$langUserHasAcceptedSession = "ΕΓΙΝΕ αποδοχή της εγγραφής στην συνεδρία από τον χρήστη:";
$langUserHasNotAcceptedSession = "ΔΕΝ έγινε αποδοχή της εγγραφής στην συνεδρία από τον χρήστη:";
$langProcessCompleted = "Ολοκληρώσατε με επιτυχία την διαδικασία.";
$langAnnouncedExistingSession = "Οι χρήστες που θα επιλεχθούν θα ενημερωθούν με σχετικό mail για να εγγραφούν στην συνεδρία.";
$langNotExistUsers = "Δεν υπάρχουν ωφελούμενοι";
$langWithConsent = "Να συναινέσει ο χρήστης για την συμμετοχή του στην συνεδρία;";
$langInfoWithConsent = "Ο χρήστης θα εγγραφεί αυτόματα στην συνεδρία αν δεν επιλεχθεί η συναίνεση χρήστη.";
$langContinueToRegistrationSession = "Η ακόλουθη διαδικασία θα οριστικοποιήσει την εγγραφή σας στην τρέχουσα συνεδρία. Θέλετε να προχωρήσετε στην συγκεκριμένη ενέργεια?";
$langCompleteRegistration = "Η εγγραφή σας ολοκληρώθηκε με επιτυχία! Έχετε εισέλθει στον χώρο της συνεδρίας σας.";
$langUserConsent = "Συναίνεση χρηστών";
$langInProgressRegistration = "Εκκρεμεί η εγγραφή του χρήστη ...";
$langSubmitRegistration = "Εγγραφή χρήστη";
$langNoSubmitRegistration = "Απεγγραφή";
$langCancelSessionRegistration = "Ο χρήστης θα απεγγραφεί προσωρινά από την τρέχουσα συνεδρία αλλά θα μπορεί να εγγραφεί ξανά.
                                  Η διαδικασία ολοκλήρωσης της συνεδρίας από τον συγκεκριμένο χρήστη δεν θα αφαιρεθεί.
                                  Για την οριστική διαγραφή του , συμπεριλαμβανομένου και της προόδου του σχετικά με την ολοκλήρωση της συνεδρίας, μπορείτε να μεταβείτε στην επιλογή <strong>επεξεργασία</strong>.</br></br>
                                  Θέλετε να συνεχίσετε?";
$langInfoAboutDelUser = "Η αφαίρεση ενός χρήστη, θα διαγράψει οριστικά και την πρόοδο του σχετικά με την ολοκλήρωση της συνεδρίας.";
$langUserReferences = "Αναφορές χρηστών";
$langUserHasCompleted = "Έχει ολοκληρώσει";
$langNotUploadedDeliverable = "Ο χρήστης δεν έχει υποβάλει κάποιο παραδοτέο";
$langNoCommentsAvailable = "Δεν υπάρχουν σχόλια";
$langTableCompletedConsulting = "Αναφορές χρηστών";
$langShowOnlySessionWithCompletionEnable = "Στον πίνακα χρηστών αναφέρονται οι συνεδρίες για τις οποίες η <strong>ολοκλήρωση συνεδρίας</strong> είναι ενεργοποιημένη.";
$langCourseIsNotCollaborative = "Μη επιτρεπτή ενέργεια. Η συνεργασία δεν είναι σε μορφή συνεδρίας";
$langSessionsTable = "Πίνακας συνεδριών";
$langSummaryScheduledSessions = "Αναφορές συνεδριών";
$langNoSessionsExist = "Δεν υπάρχουν συνεδρίες";
$langSessionHasCompletionResources = "Η συνεδρία διαθέτει πόρους ολοκλήρωσης";
$langSessionInProgress = "Βρίσκεται σε εξέλιξη";
$langNextSession = "Επόμενη προγραμματισμένη συνεδρία";
$langNoExistsNextSession = "Δεν υπάρχει προγραμματισμένη συνεδρία";
$langSessionsNotStarted = "Δεν έχουν ξεκινήσει ακόμα";
$langSessionsHasExpired = "Έχουν παρέλθει";
$langNoSessionInProgress =  "Δεν υπάρχει συνεδρία σε εξέλιξη";
$langWithMeetingCompletion = "Με την ολοκλήρωση της δια ζώσης συνάντησης";
$langContinueToCompletetionWithMeeting = "Η συνεδρία θα ολοκληρωθεί με το κριτήριο ολοκλήρωσης της προγραμματισμένης δια ζώσης συνάντησης. </br>
                                          Θέλετε να προχωρήσετε στην συγκεκριμένη ενέργεια?";
$langCompletedSessionWithMeeting = "Με την ολοκλήρωση της δια ζώσης συνάντησης";
$langCompletedSessionMeeting = "Ολοκλήρωση δια ζώσης συνάντησης";
$langInfoForbiddenAddPrereq = "Η ενέργεια που επιχειρήσατε δεν μπορεί να ολοκληρώθει καθώς η τρέχουσα συνεδρία είναι ολοκλήρωμενη από όλους τους χρήστες
                                ενώ επιλέξατε προαπαιτούμενη συνεδρία στην οποία υπάρχουν ανεκπλήρωτα κριτήρια ολοκλήρωσης.";
$langAllCompletedResources = "Οι πόροι της συνεδρίας έχουν εκτελεστεί επιτυχώς από τον χρήστη.";
$langShowReportUserTable = "Αναφορές συνεδριών χρήστη";
$langShowReportUserCurrentSession = "Αναφορά χρήστη τρέχουσας συνεδρίας";
$langCompletionResources = "Πόροι ολοκλήρωσης";
$langCompletedResources = "Ολοκληρωμένοι πόροι";
$langResourceAsActivity = "Πόροι ολοκλήρωσης συνεδρίας";
$langSessionCondition = "Κατάσταση";
$langUserHasCompletedCriteria = "Ο χρήστης έχει συμμετάσχει στους απαιτούμενους πόρους";
$langUserHasNotCompletedCriteria = "Ο χρήστης δεν έχει συμμετάσχει σε όλους τους πόρους που απαιτούνται";
$langUseOfAppInfo = "Επιλέξτε σε ποιες συνεργασίες θα χρησιμοποιείται η εφαρμογή";
$langUseOfServiceInfo = "Επιλέξτε σε ποιες συνεργασίες θα χρησιμοποιείται η υπηρεσία";
$langUsersHaveCompletedCriteria = "Οι ωφελούμενοι έχουν συμμετάσχει με επιτυχία στις δραστηριότητες ολοκλήρωσης της συνεδρίας";
$langUsersCompletedCriteriaInProgress = "Η διαδικασία ολοκλήρωσης της συνεδρίας από τους συμμετέχοντες βρίσκεται σε εξέλιξη";
$langHasParticipatedInTool = "Έχει συμμετάσχει στον πόρο";
$langHasNotParticipatedInTool = "Δεν έχει συμμετάσχει στον πόρο";
$langWithAttendanceRegistrationByConsultant = "Με καταχώριση παρουσιών";
$langNotExistAttendanceCriterion = "Δεν βρέθηκε το κριτήριο ολοκλήρωσης συνεδρίας μέσω παρουσιολογίου.</br>
                                        Προκειμένου να καταχωρίσετε τους χρήστες που συμμετείχαν στην συνεδρία,
                                        θα πρέπει να ενεργοποιήσετε το κριτήριο <strong>καταχώριση παρουσιών </strong> στην <strong>ολοκλήρωση συνεδρίας.</strong>";
$langChooseParticipatedUser = "Στον παρακάτω πίνακα επιλέξτε τους χρήστες οι οποίοι συμμετείχαν στην τρέχουσα συνεδρία.";
$langCompleteAttendUser = "Οι παρουσίες καταχωρήθηκαν στους χρήστες";
$langAddParticipationUser = "Καταχώριση παρουσίας";
$langDocsUser = "Παραδοτέα χρηστών";
$langChooseUser = "Επιλέξτε έναν χρήστη από την αναζήτηση και δοκιμάστε πάλι.";
$langNotExistFilesForUser = "Δεν υπάρχουν αρχεία για τον συγκεκριμένο χρήστη";
$langUserNotParticipatedInSessions = "Ο χρήστης δεν συμμετέχει σε συνεδρίες";
$langInfoIfTcExists = "Η επιλογή τύπου δια ζώσης έχει απενεργοποιηθεί καθώς υπάρχει σύνδεσμος τηλεδιάσκεψης στην συνεδρία.";
$langInfoIfMeetingExists = "Η επιλογή τύπου εξ αποστάσεως έχει απενεργοποιηθεί καθώς υπάρχει ενεργό το κριτήριο της ολοκλήρωσης δια ζώσης συνάντησης.";
$infoPrereqSession = "Η συνεδρία που θα επιλέξετε ως προαπαιτούμενη θα πρέπει να διαθέτει τουλάχιστον ένα κριτήριο ολοκλήρωσης.</br>
                      Διαφορετικά το σύστημα θα αγνοήσει την διαδικασία υπολογισμού προαπαιτούμενης συνεδρίας.";
